/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.kmelia.notification;

import java.util.MissingResourceException;
import org.owasp.encoder.Encode;
import org.silverpeas.components.kmelia.notification.AbstractKmeliaUserNotification;
import org.silverpeas.components.kmelia.service.KmeliaHelper;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.contribution.publication.model.PublicationDetail;
import org.silverpeas.core.node.model.NodePK;
import org.silverpeas.core.notification.user.client.constant.NotifAction;
import org.silverpeas.core.notification.user.model.NotificationResourceData;
import org.silverpeas.core.security.authorization.ComponentAccessControl;
import org.silverpeas.core.security.authorization.NodeAccessControl;
import org.silverpeas.core.template.SilverpeasTemplate;
import org.silverpeas.kernel.util.StringUtil;

public abstract class AbstractKmeliaPublicationUserNotification
extends AbstractKmeliaUserNotification<PublicationDetail> {
    private final NodePK nodePK;
    private final NotifAction action;

    protected AbstractKmeliaPublicationUserNotification(NodePK nodePK, PublicationDetail resource, NotifAction action) {
        super(resource);
        this.nodePK = nodePK;
        this.action = action;
    }

    protected boolean isUserCanBeNotified(String userId) {
        if (this.nodePK != null) {
            return NodeAccessControl.get().isUserAuthorized(userId, (Object)this.nodePK);
        }
        return ComponentAccessControl.get().isUserAuthorized(userId, (Object)this.getComponentInstanceId());
    }

    protected boolean isGroupCanBeNotified(String groupId) {
        if (this.nodePK != null) {
            return NodeAccessControl.get().isGroupAuthorized(groupId, (Object)this.nodePK);
        }
        return ComponentAccessControl.get().isGroupAuthorized(groupId, (Object)this.getComponentInstanceId());
    }

    protected void performTemplateData(String language, PublicationDetail resource, SilverpeasTemplate template) {
        User sender;
        String title;
        try {
            title = this.getBundle(language).getString(this.getBundleSubjectKey());
        }
        catch (MissingResourceException ex) {
            title = this.getTitle();
        }
        this.getNotificationMetaData().addLanguage(language, title, "");
        template.setAttribute("path", (Object)this.getPath(language));
        template.setAttribute("publication", (Object)resource);
        template.setAttribute("publicationName", (Object)Encode.forHtml((String)resource.getName(language)));
        template.setAttribute("publicationDesc", (Object)Encode.forHtml((String)resource.getDescription(language)));
        template.setAttribute("publicationKeywords", (Object)Encode.forHtml((String)resource.getKeywords(language)));
        String senderId = this.getSender();
        if (StringUtil.isDefined((String)senderId) && (sender = User.getById((String)senderId)) != null) {
            template.setAttribute("sender", (Object)sender);
            template.setAttribute("senderName", (Object)sender.getDisplayedName());
        }
    }

    protected void performNotificationResource(String language, PublicationDetail resource, NotificationResourceData notificationResourceData) {
        notificationResourceData.setResourceName(resource.getName(language));
        notificationResourceData.setResourceDescription(resource.getDescription(language));
    }

    protected boolean stopWhenNoUserToNotify() {
        return !NotifAction.REPORT.equals((Object)this.action);
    }

    protected String getResourceURL(PublicationDetail resource) {
        return KmeliaHelper.getPublicationUrl(resource, this.getNodePK());
    }

    protected NodePK getNodePK() {
        return this.nodePK;
    }

    protected final String getPath(String language) {
        if (this.nodePK == null) {
            return "";
        }
        return this.getHTMLNodePath(this.nodePK, language);
    }

    protected NotifAction getAction() {
        return this.action;
    }

    protected String getComponentInstanceId() {
        return this.getNodePK() != null ? this.getNodePK().getInstanceId() : ((PublicationDetail)this.getResource()).getInstanceId();
    }

    protected String getSender() {
        if (NotifAction.REPORT.equals((Object)this.action)) {
            return null;
        }
        if (NotifAction.CREATE.equals((Object)this.action)) {
            String userId = ((PublicationDetail)this.getResource()).getCreatorId();
            UserDetail creator = UserDetail.getById((String)userId);
            if (!creator.isActivatedState()) {
                return ((PublicationDetail)this.getResource()).getUpdaterId();
            }
            return userId;
        }
        return ((PublicationDetail)this.getResource()).getUpdaterId();
    }

    protected String getContributionAccessLinkLabelBundleKey() {
        return "kmelia.notifPublicationLinkLabel";
    }
}

