/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.quickinfo;

import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.silverpeas.components.quickinfo.model.News;
import org.silverpeas.components.quickinfo.service.QuickInfoDateComparatorDesc;
import org.silverpeas.core.date.TemporalConverter;

public class NewsByStatus {
    List<News> visibles = new ArrayList<News>();
    List<News> drafts = new ArrayList<News>();
    List<News> notYetVisibles = new ArrayList<News>();
    List<News> noMoreVisibles = new ArrayList<News>();

    public NewsByStatus(List<News> allNews, String userId) {
        for (News news : allNews) {
            if (news.isDraft()) {
                if (!news.getCreatorId().equals(userId)) continue;
                this.drafts.add(news);
                continue;
            }
            if (news.isVisible()) {
                this.visibles.add(news);
                continue;
            }
            if (news.isNoMoreVisible()) {
                this.noMoreVisibles.add(news);
                continue;
            }
            this.notYetVisibles.add(news);
        }
        this.sortByDateDesc(this.drafts);
        this.sortByDateDesc(this.visibles);
        Collections.sort(this.notYetVisibles, new QuickInfoBeginDateComparatorDesc());
        Collections.sort(this.noMoreVisibles, new QuickInfoEndDateComparatorDesc());
    }

    private void sortByDateDesc(List<News> listOfNews) {
        QuickInfoDateComparatorDesc comparator = QuickInfoDateComparatorDesc.comparator;
        Collections.sort(listOfNews, comparator);
    }

    public List<News> getVisibles() {
        return this.visibles;
    }

    public List<News> getDrafts() {
        return this.drafts;
    }

    public List<News> getNotYetVisibles() {
        return this.notYetVisibles;
    }

    public List<News> getNoMoreVisibles() {
        return this.noMoreVisibles;
    }

    class QuickInfoEndDateComparatorDesc
    implements Comparator<News> {
        QuickInfoEndDateComparatorDesc() {
        }

        @Override
        public int compare(News pd1, News pd2) {
            return TemporalConverter.asDate((Temporal)pd1.getVisibility().getPeriod().getEndDate()).compareTo(TemporalConverter.asDate((Temporal)pd2.getVisibility().getPeriod().getEndDate()));
        }
    }

    class QuickInfoBeginDateComparatorDesc
    implements Comparator<News> {
        QuickInfoBeginDateComparatorDesc() {
        }

        @Override
        public int compare(News pd1, News pd2) {
            return TemporalConverter.asDate((Temporal)pd1.getVisibility().getPeriod().getStartDate()).compareTo(TemporalConverter.asDate((Temporal)pd2.getVisibility().getPeriod().getStartDate()));
        }
    }
}

