/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.questionreply.model;

import java.text.ParseException;
import java.util.Date;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.contribution.content.wysiwyg.service.WysiwygController;
import org.silverpeas.core.contribution.model.Contribution;
import org.silverpeas.core.contribution.model.ContributionIdentifier;
import org.silverpeas.core.contribution.model.WithAttachment;
import org.silverpeas.core.i18n.I18NHelper;
import org.silverpeas.core.persistence.jdbc.bean.SilverpeasBean;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.kernel.annotation.NonNull;

public class Reply
extends SilverpeasBean
implements Contribution,
WithAttachment {
    private static final long serialVersionUID = 5638699228049557540L;
    private long questionId;
    private String title;
    private String content;
    private String wysiwygContent;
    private String creatorId;
    private String creationDate;
    private int publicReply = 0;
    private int privateReply = 1;

    public Reply() {
    }

    public Reply(String creatorId) {
        this.creatorId = creatorId;
        this.creationDate = DateUtil.date2SQLDate((Date)new Date());
    }

    public Reply(long questionId, String creatorId) {
        this(creatorId);
        this.questionId = questionId;
    }

    public long getQuestionId() {
        return this.questionId;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean canBeAccessedBy(User user) {
        return false;
    }

    public String getContent() {
        return this.content;
    }

    public String getCreatorId() {
        return this.creatorId;
    }

    public ContributionIdentifier getIdentifier() {
        return ContributionIdentifier.from((ResourceReference)new ResourceReference(this.getPK()));
    }

    public User getCreator() {
        return User.getById((String)this.getCreatorId());
    }

    public Date getCreationDate() {
        try {
            return DateUtil.parse((String)this.getCreationDateAsString());
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public User getLastUpdater() {
        return this.getCreator();
    }

    public Date getLastUpdateDate() {
        return this.getCreationDate();
    }

    public String getCreationDateAsString() {
        return this.creationDate;
    }

    public int getPublicReply() {
        return this.publicReply;
    }

    public int getPrivateReply() {
        return this.privateReply;
    }

    public void setQuestionId(long questionId) {
        this.questionId = questionId;
    }

    public void setCreatorId(String creatorId) {
        this.creatorId = creatorId;
    }

    public void setCreationDate() {
        this.setCreationDate(new Date());
    }

    public void setCreationDate(String creationDate) {
        this.creationDate = creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = DateUtil.date2SQLDate((Date)creationDate);
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setPublicReply(int publicReply) {
        this.publicReply = publicReply;
    }

    public void setPrivateReply(int privateReply) {
        this.privateReply = privateReply;
    }

    public String readCreatorName() {
        String creatorName = null;
        UserDetail userDetail = this.readAuthor();
        if (userDetail != null) {
            creatorName = userDetail.getDisplayedName();
        }
        return creatorName;
    }

    public UserDetail readAuthor() {
        return UserDetail.getById((String)this.getCreatorId());
    }

    public String loadWysiwygContent() {
        this.wysiwygContent = WysiwygController.load((String)this.getPK().getInstanceId(), (String)this.getPK().getId(), (String)I18NHelper.DEFAULT_LANGUAGE);
        return this.wysiwygContent;
    }

    public String readCurrentWysiwygContent() {
        return this.wysiwygContent;
    }

    public void writeWysiwygContent(String wysiwygContent) {
        this.wysiwygContent = wysiwygContent;
    }

    @NonNull
    protected String getTableName() {
        return "SC_QuestionReply_Reply";
    }

    public boolean isIndexable() {
        return this.getPublicReply() == 1;
    }

    public String toString() {
        return "Reply{questionId=" + this.questionId + ", title=" + this.title + ", content=" + this.content + ", creatorId=" + this.creatorId + ", creationDate=" + this.creationDate + ", publicReply=" + this.publicReply + ", privateReply=" + this.privateReply + "}";
    }
}

