/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.forums.notification;

import java.util.MissingResourceException;
import org.owasp.encoder.Encode;
import org.silverpeas.components.forums.model.ForumDetail;
import org.silverpeas.components.forums.notification.AbstractForumsUserNotification;
import org.silverpeas.core.notification.user.client.constant.NotifAction;
import org.silverpeas.core.notification.user.model.NotificationResourceData;
import org.silverpeas.core.template.SilverpeasTemplate;
import org.silverpeas.kernel.logging.SilverLogger;

public abstract class AbstractForumsForumUserNotification
extends AbstractForumsUserNotification<ForumDetail> {
    private final NotifAction action;

    public AbstractForumsForumUserNotification(ForumDetail resource, NotifAction action) {
        super(resource);
        this.action = action;
    }

    protected void perform(ForumDetail resource) {
        super.perform((Object)resource);
        this.getNotificationMetaData().displayReceiversInFooter();
    }

    protected void performTemplateData(String language, ForumDetail resource, SilverpeasTemplate template) {
        String title;
        try {
            title = this.getBundle(language).getString(this.getBundleSubjectKey());
        }
        catch (MissingResourceException ex) {
            SilverLogger.getLogger((Object)((Object)this)).warn((Throwable)ex);
            title = this.getTitle();
        }
        this.getNotificationMetaData().addLanguage(language, title, "");
        template.setAttribute("title", (Object)Encode.forHtml((String)resource.getName()));
    }

    protected void performNotificationResource(String language, ForumDetail resource, NotificationResourceData notificationResourceData) {
        notificationResourceData.setFeminineGender(false);
        notificationResourceData.setResourceName(resource.getName());
    }

    protected NotifAction getAction() {
        return this.action;
    }

    protected String getComponentInstanceId() {
        return ((ForumDetail)this.getResource()).getInstanceId();
    }

    protected String getContributionAccessLinkLabelBundleKey() {
        return "forums.notifForumLinkLabel";
    }
}

