/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.forums;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Named;
import org.silverpeas.components.forums.model.Forum;
import org.silverpeas.components.forums.model.ForumPK;
import org.silverpeas.components.forums.service.ForumsServiceProvider;
import org.silverpeas.core.annotation.Provider;
import org.silverpeas.core.silverstatistics.volume.model.UserIdCountVolumeCouple;
import org.silverpeas.core.silverstatistics.volume.service.ComponentStatisticsProvider;

@Provider
@Named(value="forumsStatistics")
public class ForumsStatistics
implements ComponentStatisticsProvider {
    public Collection<UserIdCountVolumeCouple> getVolume(String spaceId, String componentId) {
        List<Forum> forums = this.getForums(spaceId, componentId);
        ArrayList<UserIdCountVolumeCouple> couples = new ArrayList<UserIdCountVolumeCouple>(forums.size());
        for (Forum forum : forums) {
            UserIdCountVolumeCouple couple = new UserIdCountVolumeCouple();
            couple.setUserId(Integer.toString(forum.getId()));
            couple.setCountVolume(1L);
            couples.add(couple);
        }
        return couples;
    }

    private List<Forum> getForums(String spaceId, String componentId) {
        return ForumsServiceProvider.getForumsService().getForums(new ForumPK(componentId, spaceId));
    }
}

