/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.personalorganizer.service;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.silverpeas.core.admin.component.ComponentInstanceDeletion;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.index.indexing.model.FullIndexEntry;
import org.silverpeas.core.index.indexing.model.IndexEngineProxy;
import org.silverpeas.core.index.indexing.model.IndexEntryKey;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.persistence.jdbc.sql.JdbcSqlQuery;
import org.silverpeas.core.personalorganizer.model.Attendee;
import org.silverpeas.core.personalorganizer.model.Category;
import org.silverpeas.core.personalorganizer.model.HolidayDetail;
import org.silverpeas.core.personalorganizer.model.JournalHeader;
import org.silverpeas.core.personalorganizer.model.Schedulable;
import org.silverpeas.core.personalorganizer.model.SchedulableCount;
import org.silverpeas.core.personalorganizer.model.ToDoHeader;
import org.silverpeas.core.personalorganizer.model.TodoDetail;
import org.silverpeas.core.personalorganizer.service.AttendeeDAO;
import org.silverpeas.core.personalorganizer.service.CalendarException;
import org.silverpeas.core.personalorganizer.service.CalendarRuntimeException;
import org.silverpeas.core.personalorganizer.service.CategoryDAO;
import org.silverpeas.core.personalorganizer.service.HolidaysDAO;
import org.silverpeas.core.personalorganizer.service.JournalDAO;
import org.silverpeas.core.personalorganizer.service.SilverpeasCalendar;
import org.silverpeas.core.personalorganizer.service.ToDoDAO;
import org.silverpeas.core.personalorganizer.socialnetwork.SocialInformationEvent;
import org.silverpeas.core.util.ArrayUtil;
import org.silverpeas.core.util.SilverpeasList;
import org.silverpeas.kernel.logging.SilverLogger;

@Service
@Transactional(value=Transactional.TxType.SUPPORTS)
public class DefaultCalendarService
implements SilverpeasCalendar,
ComponentInstanceDeletion {
    private static final String CANNOT_GET_JOURNALS_OF_USER = "Cannot get journals of user ";
    private static final String NO_SUCH_JOURNAL = "No such journal ";
    private static final String ERROR_WHILE_PARSING_THE_DATES_OF_A_JOURNAL = "Error while parsing the dates of a journal";
    private static final String IDX_USER_PREFIX = "user@";
    private static final String CANNOT_GET_JOURNALS = "Cannot get journals";
    @Inject
    private JournalDAO journalDAO;

    private Connection getConnection() {
        try {
            return DBUtil.openConnection();
        }
        catch (Exception e) {
            throw new CalendarRuntimeException("Cannot open connection");
        }
    }

    @Override
    public boolean hasTentativeSchedulablesForUser(String userId) {
        Connection con = this.getConnection();
        try {
            boolean bl = this.getJournalDAO().hasTentativeJournalsForUser(con, userId);
            return bl;
        }
        catch (Exception e) {
            throw new CalendarRuntimeException(CANNOT_GET_JOURNALS_OF_USER + userId, e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public Collection<JournalHeader> getTentativeSchedulablesForUser(String userId) {
        Connection con = this.getConnection();
        try {
            Collection<JournalHeader> collection = this.getJournalDAO().getTentativeJournalHeadersForUser(con, userId);
            return collection;
        }
        catch (Exception e) {
            throw new CalendarRuntimeException(CANNOT_GET_JOURNALS_OF_USER + userId, e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public SilverpeasList<ToDoHeader> getNotCompletedToDosForUser(String userId) {
        try {
            return ToDoDAO.getNotCompletedToDoHeadersForUser(userId);
        }
        catch (Exception e) {
            throw new CalendarRuntimeException("Cannot get todos of user " + userId, e);
        }
    }

    @Override
    public List<String> getAllToDoForUser(String userId) {
        try {
            return ToDoDAO.getAllTodoByUser(userId);
        }
        catch (Exception e) {
            throw new CalendarRuntimeException("Cannot get todos of user " + userId, e);
        }
    }

    @Override
    public SilverpeasList<ToDoHeader> getOrganizerToDos(String organizerId) {
        try {
            return ToDoDAO.getOrganizerToDoHeaders(organizerId);
        }
        catch (Exception e) {
            throw new CalendarRuntimeException("Cannot get journals from organizer " + organizerId, e);
        }
    }

    @Override
    public SilverpeasList<ToDoHeader> getClosedToDos(String organizerId) {
        try {
            return ToDoDAO.getClosedToDoHeaders(organizerId);
        }
        catch (Exception e) {
            throw new CalendarRuntimeException("Cannot get journals from organizer " + organizerId, e);
        }
    }

    @Override
    public Collection<ToDoHeader> getExternalTodos(String spaceId, String componentId, String externalId) {
        try {
            return ToDoDAO.getToDoHeadersByExternalId(componentId, externalId);
        }
        catch (Exception e) {
            throw new CalendarRuntimeException("Cannot get journals in space " + spaceId + ", application " + componentId + ", and external resource " + externalId, e);
        }
    }

    @Override
    public ToDoHeader getToDoHeader(String todoId) {
        try {
            return ToDoDAO.getToDoHeader(todoId);
        }
        catch (Exception e) {
            throw new CalendarRuntimeException("Cannot get the todo " + todoId, e);
        }
    }

    @Override
    public TodoDetail getTodoDetail(String id) {
        try {
            TodoDetail detail = TodoDetail.fromToDoHeader(this.getToDoHeader(id));
            ArrayList<Attendee> attendees = new ArrayList<Attendee>(this.getToDoAttendees(id));
            detail.setAttendees(attendees);
            return detail;
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private Collection<ToDoHeader> getToDoHeadersByInstanceId(String instanceId) {
        try {
            return ToDoDAO.getToDoHeadersByInstanceId(instanceId);
        }
        catch (Exception e) {
            throw new CalendarRuntimeException("Cannot get todos in application " + instanceId, e);
        }
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public void updateToDo(ToDoHeader todo) {
        this.checkTodo(todo);
        Connection con = this.getConnection();
        try {
            ToDoDAO.updateToDo(con, todo);
            this.createIndex(todo, todo.getDelegatorId());
            List<Attendee> attendees = this.getToDoAttendees(todo.getId());
            for (Attendee attendee : attendees) {
                this.createIndex(todo, attendee.getUserId());
            }
        }
        catch (Exception e) {
            throw new CalendarRuntimeException("Cannot update the todo " + todo.getId(), e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    private void checkTodo(ToDoHeader todo) {
        if (todo.getName() == null) {
            throw new CalendarRuntimeException("Todo's name is null!");
        }
        if (todo.getDelegatorId() == null) {
            throw new CalendarRuntimeException("Todo's delegator is null!");
        }
        if (todo.getEndDate() != null && todo.getStartDate() != null && todo.getStartDate().after(todo.getEndDate())) {
            throw new CalendarRuntimeException("The todo period is incorrect!");
        }
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public String addToDo(ToDoHeader todo) {
        this.checkTodo(todo);
        Connection con = this.getConnection();
        try {
            String result = ToDoDAO.addToDo(con, todo);
            todo.setId(result);
            this.createIndex(todo, todo.getDelegatorId());
            String string = result;
            return string;
        }
        catch (Exception e) {
            throw new CalendarRuntimeException("Cannot create new todo", e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public String addToDo(TodoDetail todo) {
        try {
            ToDoHeader header = ToDoHeader.fromTodoDetail(todo);
            String id = this.addToDo(header);
            if (todo.getAttendees() != null) {
                for (Attendee attendee : todo.getAttendees()) {
                    this.addToDoAttendee(id, attendee);
                }
            }
            return id;
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public void removeToDo(String id) {
        ToDoHeader todo = this.getToDoHeader(id);
        try {
            this.setToDoAttendees(id, ArrayUtil.emptyStringArray());
            ToDoDAO.removeToDo(id);
        }
        catch (Exception e) {
            throw new CalendarRuntimeException("Cannot delete todo " + id, e);
        }
        this.removeIndex(todo, todo.getDelegatorId());
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public void removeToDoFromExternal(String spaceId, String componentId, String externalId) {
        try {
            Collection<ToDoHeader> headers = this.getExternalTodos(spaceId, componentId, externalId);
            for (ToDoHeader header : headers) {
                this.removeToDo(header.getId());
            }
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public void removeAttendeeInToDoFromExternal(String componentId, String externalId, String userId) {
        try {
            Attendee attendee = new Attendee();
            attendee.setUserId(userId);
            Collection<ToDoHeader> headers = this.getExternalTodos("useless", componentId, externalId);
            for (ToDoHeader header : headers) {
                if (header == null) continue;
                this.removeToDoAttendee(header.getId(), attendee);
            }
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Collection<JournalHeader> getDaySchedulablesForUser(String day, String userId, String categoryId, String participation) {
        Connection con = this.getConnection();
        try {
            Collection<JournalHeader> collection = this.getJournalDAO().getDayJournalHeadersForUser(con, day, userId, categoryId, participation);
            return collection;
        }
        catch (Exception e) {
            throw new CalendarRuntimeException(CANNOT_GET_JOURNALS_OF_USER + userId, e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public Collection<JournalHeader> getNextDaySchedulablesForUser(String day, String userId, String categoryId, String participation) {
        Connection con = this.getConnection();
        try {
            Collection<JournalHeader> collection = this.getJournalDAO().getNextJournalHeadersForUser(con, day, userId, categoryId, participation);
            return collection;
        }
        catch (Exception e) {
            throw new CalendarRuntimeException(CANNOT_GET_JOURNALS_OF_USER + userId, e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public Collection<JournalHeader> getPeriodSchedulablesForUser(String begin, String end, String userId, String categoryId, String participation) {
        Connection con = this.getConnection();
        try {
            Collection<JournalHeader> collection = this.getJournalDAO().getPeriodJournalHeadersForUser(con, begin, end, userId, categoryId, participation);
            return collection;
        }
        catch (Exception e) {
            throw new CalendarRuntimeException(CANNOT_GET_JOURNALS_OF_USER + userId, e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public Collection<SchedulableCount> countMonthSchedulablesForUser(String month, String userId, String categoryId, String participation) {
        Connection con = this.getConnection();
        try {
            Collection<SchedulableCount> collection = this.getJournalDAO().countMonthJournalsForUser(con, month, userId, categoryId, participation);
            return collection;
        }
        catch (Exception e) {
            throw new CalendarRuntimeException(CANNOT_GET_JOURNALS_OF_USER + userId, e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public String addJournal(JournalHeader journal) {
        this.validateJournal(journal);
        Connection con = this.getConnection();
        try {
            String result = this.getJournalDAO().addJournal(con, journal);
            journal.setId(result);
            this.createIndex(journal, journal.getDelegatorId());
            String string = result;
            return string;
        }
        catch (Exception e) {
            throw new CalendarRuntimeException("Cannot add journal", e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public void updateJournal(JournalHeader journal) {
        this.validateJournal(journal);
        Connection con = this.getConnection();
        try {
            this.getJournalDAO().updateJournal(con, journal);
            this.createIndex(journal, journal.getDelegatorId());
            Collection<Attendee> attendees = this.getJournalAttendees(journal.getId());
            for (Attendee attendee : attendees) {
                this.createIndex(journal, attendee.getUserId());
            }
        }
        catch (SQLException se) {
            throw new CalendarRuntimeException("Cannot update journal " + journal.getId(), se);
        }
        catch (CalendarException ce) {
            throw new CalendarRuntimeException(NO_SUCH_JOURNAL + journal.getId(), (Throwable)((Object)ce));
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    private void validateJournal(JournalHeader journal) {
        if (journal.getName() == null) {
            throw new CalendarRuntimeException("The journal's name is null!");
        }
        if (journal.getStartDate() == null) {
            throw new CalendarRuntimeException("The journal's starting date is null!");
        }
        if (journal.getDelegatorId() == null) {
            throw new CalendarRuntimeException("The journal's delegator is null!");
        }
        if (journal.getStartDate().after(journal.getEndDate())) {
            throw new CalendarRuntimeException("The journal's period is invalid!");
        }
        if (journal.getStartHour() != null && journal.getEndHour() == null) {
            throw new CalendarRuntimeException("The journal doesn't end!");
        }
        if (journal.getEndHour() != null && journal.getStartHour() == null) {
            throw new CalendarRuntimeException("The journal starting hour isn't defined!");
        }
        if (journal.getStartDate().equals(journal.getEndDate()) && journal.getStartHour() != null && journal.getStartHour().compareTo(journal.getEndHour()) > 0) {
            throw new CalendarRuntimeException("The journal period is invalid!");
        }
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public void removeJournal(String journalId) {
        Connection con = this.getConnection();
        try {
            JournalHeader journal = this.getJournalHeader(journalId);
            this.setJournalAttendees(journalId, ArrayUtil.emptyStringArray());
            CategoryDAO.removeJournal(con, journalId);
            this.getJournalDAO().removeJournal(con, journalId);
            this.removeIndex(journal, journal.getDelegatorId());
        }
        catch (SQLException se) {
            throw new CalendarRuntimeException("Cannot remove journal " + journalId, se);
        }
        catch (CalendarException ce) {
            throw new CalendarRuntimeException(NO_SUCH_JOURNAL + journalId, (Throwable)((Object)ce));
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public JournalHeader getJournalHeader(String journalId) {
        Connection con = this.getConnection();
        try {
            JournalHeader journalHeader = this.getJournalDAO().getJournalHeader(con, journalId);
            return journalHeader;
        }
        catch (SQLException se) {
            throw new CalendarRuntimeException("Cannot get journal " + journalId, se);
        }
        catch (ParseException pe) {
            throw new CalendarRuntimeException("Cannot parse dates of journal " + journalId, pe);
        }
        catch (CalendarException ce) {
            throw new CalendarRuntimeException(NO_SUCH_JOURNAL + journalId, (Throwable)((Object)ce));
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public Collection<JournalHeader> getExternalJournalHeadersForUser(String userId) {
        Collection<JournalHeader> collection;
        block9: {
            Connection con = this.getConnection();
            try {
                collection = this.getJournalDAO().getOutlookJournalHeadersForUser(con, userId);
                if (con == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException se) {
                    throw new CalendarRuntimeException(CANNOT_GET_JOURNALS_OF_USER + userId, se);
                }
                catch (ParseException pe) {
                    throw new CalendarRuntimeException(ERROR_WHILE_PARSING_THE_DATES_OF_A_JOURNAL, pe);
                }
            }
            con.close();
        }
        return collection;
    }

    @Override
    public Collection<JournalHeader> getExternalJournalHeadersForUserAfterDate(String userId, Date startDate) {
        Collection<JournalHeader> collection;
        block9: {
            Connection con = this.getConnection();
            try {
                collection = this.getJournalDAO().getOutlookJournalHeadersForUserAfterDate(con, userId, startDate);
                if (con == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException se) {
                    throw new CalendarRuntimeException(CANNOT_GET_JOURNALS_OF_USER + userId, se);
                }
                catch (ParseException pe) {
                    throw new CalendarRuntimeException(ERROR_WHILE_PARSING_THE_DATES_OF_A_JOURNAL, pe);
                }
            }
            con.close();
        }
        return collection;
    }

    @Override
    public Collection<JournalHeader> getJournalHeadersForUserAfterDate(String userId, Date startDate, int nbReturned) {
        Collection<JournalHeader> collection;
        block9: {
            Connection con = this.getConnection();
            try {
                collection = this.getJournalDAO().getJournalHeadersForUserAfterDate(con, userId, startDate, nbReturned);
                if (con == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException se) {
                    throw new CalendarRuntimeException(CANNOT_GET_JOURNALS_OF_USER + userId, se);
                }
                catch (ParseException pe) {
                    throw new CalendarRuntimeException(ERROR_WHILE_PARSING_THE_DATES_OF_A_JOURNAL, pe);
                }
            }
            con.close();
        }
        return collection;
    }

    @Override
    public void addJournalAttendee(String journalId, Attendee attendee) {
        try (Connection con = this.getConnection();){
            AttendeeDAO.addJournalAttendee(con, journalId, attendee);
            this.createIndex(this.getJournalHeader(journalId), attendee.getUserId());
        }
        catch (Exception e) {
            throw new CalendarRuntimeException("Cannot add attendee to the journal " + journalId, e);
        }
    }

    @Override
    public void removeJournalAttendee(String journalId, Attendee attendee) {
        try (Connection con = this.getConnection();){
            AttendeeDAO.removeJournalAttendee(con, journalId, attendee);
            this.removeIndex(this.getJournalHeader(journalId), attendee.getUserId());
        }
        catch (Exception e) {
            throw new CalendarRuntimeException("Cannot remove attendee to the journal " + journalId, e);
        }
    }

    @Override
    public Collection<Attendee> getJournalAttendees(String journalId) {
        try {
            return AttendeeDAO.getJournalAttendees(journalId);
        }
        catch (Exception e) {
            throw new CalendarRuntimeException("Cannot get attendees to the journal " + journalId, e);
        }
    }

    @Override
    public void setJournalAttendees(String journalId, String[] userIds) {
        Collection<Attendee> current = this.getJournalAttendees(journalId);
        JournalHeader journalHeader = this.getJournalHeader(journalId);
        List<Object> usersToAdd = userIds != null ? Arrays.asList(userIds) : Collections.emptyList();
        current.stream().filter(a -> !usersToAdd.contains(a.getUserId())).forEach(a -> this.removeJournalAttendee(journalId, new Attendee(a.getUserId())));
        List attendees = current.stream().map(Attendee::getUserId).collect(Collectors.toList());
        usersToAdd.stream().filter(u -> attendees.stream().noneMatch(a -> a.equals(u))).forEach(u -> {
            Attendee attendee = u.equals(journalHeader.getDelegatorId()) ? new Attendee((String)u, "accepted") : new Attendee((String)u);
            this.addJournalAttendee(journalId, attendee);
        });
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public void setJournalParticipationStatus(String journalId, String userId, String participation) {
        Attendee attendee = new Attendee(userId, participation);
        Connection con = this.getConnection();
        try {
            AttendeeDAO.removeJournalAttendee(con, journalId, attendee);
            AttendeeDAO.addJournalAttendee(con, journalId, attendee);
        }
        catch (Exception e) {
            throw new CalendarRuntimeException("Cannot update the journal " + journalId, e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public void addToDoAttendee(String todoId, Attendee attendee) {
        Connection con = this.getConnection();
        try {
            AttendeeDAO.addToDoAttendee(con, todoId, attendee);
            this.createIndex(this.getToDoHeader(todoId), attendee.getUserId());
        }
        catch (Exception e) {
            throw new CalendarRuntimeException("Cannot add attendee to the todo " + todoId, e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public void removeToDoAttendee(String todoId, Attendee attendee) {
        Connection con = this.getConnection();
        try {
            AttendeeDAO.removeToDoAttendee(con, todoId, attendee);
            this.removeIndex(this.getToDoHeader(todoId), attendee.getUserId());
        }
        catch (Exception e) {
            throw new CalendarRuntimeException("Cannot remove attendee to the todo " + todoId, e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public List<Attendee> getToDoAttendees(String todoId) {
        try {
            return AttendeeDAO.getToDoAttendees(todoId);
        }
        catch (Exception e) {
            throw new CalendarRuntimeException("Cannot get attendees to the todo " + todoId, e);
        }
    }

    @Override
    public Map<String, List<Attendee>> getToDoAttendees(Collection<String> todoIds) {
        try {
            return AttendeeDAO.getToDoAttendees(todoIds);
        }
        catch (Exception e) {
            throw new CalendarRuntimeException("Cannot add attendees to several todos", e);
        }
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public void setToDoAttendees(String todoId, String[] userIds) {
        List<Attendee> current = this.getToDoAttendees(todoId);
        List<Object> usersToAdd = userIds != null ? Arrays.asList(userIds) : Collections.emptyList();
        current.stream().filter(a -> !usersToAdd.contains(a.getUserId())).forEach(a -> this.removeToDoAttendee(todoId, new Attendee(a.getUserId())));
        List attendees = current.stream().map(Attendee::getUserId).collect(Collectors.toList());
        usersToAdd.stream().filter(u -> attendees.stream().noneMatch(a -> a.equals(u))).forEach(u -> {
            Attendee attendee = new Attendee((String)u);
            this.addToDoAttendee(todoId, attendee);
        });
    }

    @Override
    public Collection<Category> getAllCategories() {
        Connection con = this.getConnection();
        try {
            Collection<Category> collection = CategoryDAO.getAllCategories(con);
            return collection;
        }
        catch (Exception e) {
            throw new CalendarRuntimeException("Cannot get all the categories", e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public Category getCategory(String categoryId) {
        Connection con = this.getConnection();
        try {
            Category category = CategoryDAO.getCategory(con, categoryId);
            return category;
        }
        catch (Exception e) {
            throw new CalendarRuntimeException("Cannot get category " + categoryId, e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public void addJournalCategory(String journalId, String categoryId) {
        Connection con = this.getConnection();
        try {
            CategoryDAO.addJournalCategory(con, journalId, categoryId);
        }
        catch (Exception e) {
            throw new CalendarRuntimeException("Cannot add journal " + journalId + " in category " + categoryId, e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public void removeJournalCategory(String journalId, String categoryId) {
        Connection con = this.getConnection();
        try {
            CategoryDAO.removeJournalCategory(con, journalId, categoryId);
        }
        catch (Exception e) {
            throw new CalendarRuntimeException("Cannot remove journal " + journalId + " from category " + categoryId, e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public Collection<Category> getJournalCategories(String journalId) {
        Connection con = this.getConnection();
        try {
            Collection<Category> collection = CategoryDAO.getJournalCategories(con, journalId);
            return collection;
        }
        catch (Exception e) {
            throw new CalendarRuntimeException("Cannot get all the categories of journal " + journalId, e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public void setJournalCategories(String journalId, String[] categoryIds) {
        Collection<Category> current = this.getJournalCategories(journalId);
        List<Object> categoriesToAdd = categoryIds != null ? Arrays.asList(categoryIds) : Collections.emptyList();
        current.stream().filter(c -> !categoriesToAdd.contains(c.getId())).forEach(c -> this.removeJournalCategory(journalId, c.getId()));
        List categories = current.stream().map(Category::getId).collect(Collectors.toList());
        categoriesToAdd.stream().filter(c1 -> categories.stream().noneMatch(c2 -> c2.equals(c1))).forEach(c -> this.addJournalCategory(journalId, (String)c));
    }

    @Override
    public void indexAllTodo() {
        ArrayList todos = new ArrayList(1500);
        ArrayList todoIds = new ArrayList(1500);
        Consumer<List> indexationProcess = l -> {
            Map<String, List<Attendee>> attendeeMapping = this.getToDoAttendees(todoIds);
            for (ToDoHeader todo : todos) {
                this.createIndex(todo, todo.getDelegatorId());
                Collection attendees = attendeeMapping.getOrDefault(todo.getId(), Collections.emptyList());
                for (Attendee attendee : attendees) {
                    this.createIndex(todo, attendee.getUserId());
                }
            }
        };
        try {
            JdbcSqlQuery.select((String)"id, name, delegatorId, description, priority, classification, startDay, startHour, endDay, endHour, percentCompleted, completedDay, duration, spaceId, componentId, externalId").from(new String[]{"CalendarToDo"}).execute(rs -> {
                ToDoHeader todo = ToDoDAO.getToDoHeaderFromResultSet((ResultSet)rs);
                todos.add(todo);
                todoIds.add(todo.getId());
                if (todoIds.size() == 1500) {
                    indexationProcess.accept(todoIds);
                    todos.clear();
                    todoIds.clear();
                }
                return null;
            });
            indexationProcess.accept(todoIds);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public List<String> getHolidayDates(String userId) {
        Connection con = this.getConnection();
        try {
            List<String> list = HolidaysDAO.getHolidayDates(con, userId);
            return list;
        }
        catch (Exception re) {
            throw new CalendarRuntimeException("Cannot get holiday dates of user " + userId, re);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public List<String> getHolidayDates(String userId, Date beginDate, Date endDate) {
        Connection con = this.getConnection();
        try {
            List<String> list = HolidaysDAO.getHolidayDates(con, userId, beginDate, endDate);
            return list;
        }
        catch (Exception re) {
            throw new CalendarRuntimeException("Cannot get holiday dates of user " + userId, re);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public void addHolidayDate(HolidayDetail holiday) {
        Connection con = this.getConnection();
        try {
            HolidaysDAO.addHolidayDate(con, holiday);
        }
        catch (Exception re) {
            throw new CalendarRuntimeException("Cannot add holiday date", re);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public void addHolidayDates(List<HolidayDetail> holidayDates) {
        Connection con = this.getConnection();
        try {
            for (HolidayDetail holiday : holidayDates) {
                HolidaysDAO.addHolidayDate(con, holiday);
            }
        }
        catch (Exception re) {
            throw new CalendarRuntimeException("Cannot add holiday dates", re);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public void removeHolidayDate(HolidayDetail holiday) {
        Connection con = this.getConnection();
        try {
            HolidaysDAO.removeHolidayDate(con, holiday);
        }
        catch (Exception re) {
            throw new CalendarRuntimeException("Cannot remove holiday date", re);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public void removeHolidayDates(List<HolidayDetail> holidayDates) {
        Connection con = this.getConnection();
        try {
            for (HolidayDetail holiday : holidayDates) {
                HolidaysDAO.removeHolidayDate(con, holiday);
            }
        }
        catch (Exception re) {
            throw new CalendarRuntimeException("Cannot remove holiday dates", re);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public boolean isHolidayDate(HolidayDetail date) {
        Connection con = this.getConnection();
        try {
            boolean bl = HolidaysDAO.isHolidayDate(con, date);
            return bl;
        }
        catch (Exception re) {
            throw new CalendarRuntimeException("Cannot get holiday date", re);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public void indexAllJournal() {
        String selectStatement = "select id, name, delegatorId, description, priority, classification, startDay, startHour, endDay, endHour, externalId from CalendarJournal";
        try (Connection con = DBUtil.openConnection();
             Statement prepStmt = con.createStatement();
             ResultSet rs = prepStmt.executeQuery("select id, name, delegatorId, description, priority, classification, startDay, startHour, endDay, endHour, externalId from CalendarJournal");){
            while (rs.next()) {
                JournalHeader journal = this.getJournalDAO().getJournalHeaderFromResultSet(rs);
                this.createIndex(journal, journal.getDelegatorId());
                Collection<Attendee> attendees = this.getJournalAttendees(journal.getId());
                for (Attendee attendee : attendees) {
                    this.createIndex(journal, attendee.getUserId());
                }
            }
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
        }
    }

    private void createIndex(Schedulable detail, String userId) {
        try {
            FullIndexEntry indexEntry = detail instanceof ToDoHeader ? new FullIndexEntry(new IndexEntryKey(IDX_USER_PREFIX + userId + "_todo", "todo", detail.getId())) : new FullIndexEntry(new IndexEntryKey(IDX_USER_PREFIX + userId + "_agenda", "agenda", detail.getId()));
            indexEntry.setTitle(detail.getName());
            indexEntry.setPreview(detail.getDescription());
            indexEntry.setCreationUser(detail.getDelegatorId());
            IndexEngineProxy.addIndexEntry((FullIndexEntry)indexEntry);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
        }
    }

    private void removeIndex(Schedulable detail, String userId) {
        try {
            IndexEntryKey indexEntry = this.getIndexEntry(detail, userId);
            IndexEngineProxy.removeIndexEntry((IndexEntryKey)indexEntry);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error((Throwable)e);
        }
    }

    private IndexEntryKey getIndexEntry(Schedulable detail, String userId) {
        IndexEntryKey indexEntry = detail instanceof ToDoHeader ? new IndexEntryKey(IDX_USER_PREFIX + userId + "_todo", "todo", detail.getId()) : new IndexEntryKey(IDX_USER_PREFIX + userId + "_agenda", "agenda", detail.getId());
        return indexEntry;
    }

    @Override
    public List<JournalHeader> getNextEventsForUser(String day, String userId, String classification, Date begin, Date end) {
        Connection con = this.getConnection();
        try {
            List<JournalHeader> list = this.getJournalDAO().getNextEventsForUser(con, day, userId, classification, begin, end);
            return list;
        }
        catch (Exception e) {
            throw new CalendarRuntimeException(CANNOT_GET_JOURNALS, e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public List<SocialInformationEvent> getNextEventsForMyContacts(String day, String myId, List<String> myContactsIds, Date begin, Date end) {
        Connection con = this.getConnection();
        try {
            List<SocialInformationEvent> list = this.getJournalDAO().getNextEventsForMyContacts(con, day, myId, myContactsIds, begin, end);
            return list;
        }
        catch (Exception e) {
            throw new CalendarRuntimeException(CANNOT_GET_JOURNALS, e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public List<SocialInformationEvent> getLastEventsForMyContacts(String day, String myId, List<String> myContactsIds, Date begin, Date end) {
        Connection con = this.getConnection();
        try {
            List<SocialInformationEvent> list = this.getJournalDAO().getLastEventsForMyContacts(con, day, myId, myContactsIds, begin, end);
            return list;
        }
        catch (Exception e) {
            throw new CalendarRuntimeException(CANNOT_GET_JOURNALS, e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public List<SocialInformationEvent> getMyLastEvents(String day, String myId, Date begin, Date end) {
        Connection con = this.getConnection();
        try {
            List<SocialInformationEvent> list = this.getJournalDAO().getMyLastEvents(con, day, myId, begin, end);
            return list;
        }
        catch (Exception e) {
            throw new CalendarRuntimeException(CANNOT_GET_JOURNALS, e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Transactional
    public void delete(String componentInstanceId) {
        Collection<ToDoHeader> todosToRemove = this.getToDoHeadersByInstanceId(componentInstanceId);
        for (ToDoHeader todo : todosToRemove) {
            try {
                ToDoDAO.removeToDo(todo.getId());
                AttendeeDAO.removeToDo(todo.getId());
            }
            catch (Exception e) {
                throw new CalendarRuntimeException("Cannot delete todos", e);
            }
            this.removeIndex(todo, todo.getDelegatorId());
        }
    }

    private JournalDAO getJournalDAO() {
        return this.journalDAO;
    }
}

