/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.delegate;

import javax.jcr.RepositoryException;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.AccessControlPolicyIterator;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.oak.jcr.delegate.SessionDelegate;
import org.apache.jackrabbit.oak.jcr.session.operation.SessionOperation;
import org.jetbrains.annotations.NotNull;

public class AccessControlManagerDelegator
implements AccessControlManager {
    private final SessionDelegate delegate;
    private final AccessControlManager acManager;

    public AccessControlManagerDelegator(@NotNull SessionDelegate delegate, @NotNull AccessControlManager acManager) {
        this.acManager = acManager;
        this.delegate = delegate;
    }

    public Privilege[] getSupportedPrivileges(final String absPath) throws RepositoryException {
        return this.delegate.perform(new SessionOperation<Privilege[]>("getSupportedPrivileges"){

            @Override
            @NotNull
            public @NotNull Privilege @NotNull [] perform() throws RepositoryException {
                return AccessControlManagerDelegator.this.acManager.getSupportedPrivileges(absPath);
            }
        });
    }

    public Privilege privilegeFromName(final String privilegeName) throws RepositoryException {
        return this.delegate.perform(new SessionOperation<Privilege>("privilegeFromName"){

            @Override
            @NotNull
            public Privilege perform() throws RepositoryException {
                return AccessControlManagerDelegator.this.acManager.privilegeFromName(privilegeName);
            }
        });
    }

    public boolean hasPrivileges(final String absPath, final Privilege[] privileges) throws RepositoryException {
        return this.delegate.perform(new SessionOperation<Boolean>("hasPrivileges"){

            @Override
            @NotNull
            public Boolean perform() throws RepositoryException {
                return AccessControlManagerDelegator.this.acManager.hasPrivileges(absPath, privileges);
            }
        });
    }

    public Privilege[] getPrivileges(final String absPath) throws RepositoryException {
        return this.delegate.perform(new SessionOperation<Privilege[]>("getPrivileges"){

            @Override
            public Privilege @NotNull [] perform() throws RepositoryException {
                return AccessControlManagerDelegator.this.acManager.getPrivileges(absPath);
            }
        });
    }

    public AccessControlPolicy[] getPolicies(final String absPath) throws RepositoryException {
        return this.delegate.perform(new SessionOperation<AccessControlPolicy[]>("getPolicies"){

            @Override
            public AccessControlPolicy @NotNull [] perform() throws RepositoryException {
                return AccessControlManagerDelegator.this.acManager.getPolicies(absPath);
            }
        });
    }

    public AccessControlPolicy[] getEffectivePolicies(final String absPath) throws RepositoryException {
        return this.delegate.perform(new SessionOperation<AccessControlPolicy[]>("getEffectivePolicies"){

            @Override
            public AccessControlPolicy @NotNull [] perform() throws RepositoryException {
                return AccessControlManagerDelegator.this.acManager.getEffectivePolicies(absPath);
            }
        });
    }

    public AccessControlPolicyIterator getApplicablePolicies(final String absPath) throws RepositoryException {
        return this.delegate.perform(new SessionOperation<AccessControlPolicyIterator>("getApplicablePolicies"){

            @Override
            @NotNull
            public AccessControlPolicyIterator perform() throws RepositoryException {
                return AccessControlManagerDelegator.this.acManager.getApplicablePolicies(absPath);
            }
        });
    }

    public void setPolicy(final String absPath, final AccessControlPolicy policy) throws RepositoryException {
        this.delegate.performVoid(new SessionOperation<Void>("setPolicy", true){

            @Override
            public void performVoid() throws RepositoryException {
                AccessControlManagerDelegator.this.acManager.setPolicy(absPath, policy);
            }
        });
    }

    public void removePolicy(final String absPath, final AccessControlPolicy policy) throws RepositoryException {
        this.delegate.performVoid(new SessionOperation<Void>("removePolicy", true){

            @Override
            public void performVoid() throws RepositoryException {
                AccessControlManagerDelegator.this.acManager.removePolicy(absPath, policy);
            }
        });
    }
}

