/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.jackrabbit.guava.common.base.Stopwatch;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.Document;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.JournalEntry;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.UpdateOp;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JournalGarbageCollector {
    private static final Logger log = LoggerFactory.getLogger(JournalGarbageCollector.class);
    private static final String JOURNAL_GC_ID = "journalGC";
    private static final String TAIL_TIMESTAMP = "tailTimestamp";
    private final DocumentNodeStore ns;
    private final long maxRevisionAgeMillis;
    private volatile long lastTailTimestampRefresh = Long.MIN_VALUE;
    private Revision tailRevision;

    public JournalGarbageCollector(DocumentNodeStore nodeStore, long maxRevisionAgeMillis) {
        this.ns = nodeStore;
        this.maxRevisionAgeMillis = maxRevisionAgeMillis;
        this.tailRevision = new Revision(0L, 0, this.ns.getClusterId());
    }

    public int gc() {
        DocumentStore ds = this.ns.getDocumentStore();
        Revision checkpointRev = this.ns.getCheckpoints().getOldestRevisionToKeep();
        Long keep = null;
        if (checkpointRev != null) {
            keep = checkpointRev.getTimestamp() - this.maxRevisionAgeMillis / 2L;
        }
        long now = this.ns.getClock().getTime();
        long gcOlderThan = now - this.maxRevisionAgeMillis;
        if (keep != null && keep < gcOlderThan) {
            gcOlderThan = keep;
            log.debug("gc: Checkpoint {} is older than maxRevisionAge: {} min", (Object)keep, (Object)TimeUnit.MILLISECONDS.toMinutes(this.maxRevisionAgeMillis));
        }
        if (log.isDebugEnabled()) {
            log.debug("gc: Journal garbage collection starts with maxAge: {} min.", (Object)TimeUnit.MILLISECONDS.toMinutes(this.maxRevisionAgeMillis));
        }
        Stopwatch sw = Stopwatch.createStarted();
        this.updateTailTimestamp(gcOlderThan);
        int numDeleted = ds.remove(Collection.JOURNAL, "_modified", 0L, gcOlderThan);
        sw.stop();
        if (numDeleted > 0) {
            log.info("gc: Journal garbage collection took {}, deleted {} entries that were older than {} min.", new Object[]{sw, numDeleted, TimeUnit.MILLISECONDS.toMinutes(now - gcOlderThan)});
        }
        return numDeleted;
    }

    private void updateTailTimestamp(long gcOlderThan) {
        UpdateOp op = new UpdateOp(JOURNAL_GC_ID, true);
        op.max(TAIL_TIMESTAMP, Long.valueOf(gcOlderThan));
        this.ns.getDocumentStore().createOrUpdate(Collection.SETTINGS, op);
    }

    public Revision getTailRevision() {
        this.refreshTailRevisionIfNecessary();
        return this.tailRevision;
    }

    long getMaxRevisionAgeMillis() {
        return this.maxRevisionAgeMillis;
    }

    private void refreshTailRevisionIfNecessary() {
        long now = this.ns.getClock().getTime();
        if (this.lastTailTimestampRefresh + TimeUnit.MINUTES.toMillis(1L) > now) {
            return;
        }
        this.lastTailTimestampRefresh = now;
        Document doc = this.ns.getDocumentStore().find(Collection.SETTINGS, JOURNAL_GC_ID);
        if (doc == null) {
            return;
        }
        Long ts = Utils.asLong((Number)doc.get(TAIL_TIMESTAMP));
        if (ts != null) {
            this.tailRevision = Utils.max(this.tailRevision, new Revision(ts, 0, this.ns.getClusterId()));
        }
    }

    private List<String> asKeys(List<JournalEntry> deletionBatch) {
        ArrayList<String> keys = new ArrayList<String>(deletionBatch.size());
        for (JournalEntry e : deletionBatch) {
            keys.add(e.getId());
        }
        return keys;
    }
}

