/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.query.ast;

import java.util.List;
import java.util.Set;
import org.apache.jackrabbit.oak.api.PropertyValue;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.memory.PropertyValues;
import org.apache.jackrabbit.oak.query.ast.AstVisitor;
import org.apache.jackrabbit.oak.query.ast.DynamicOperandImpl;
import org.apache.jackrabbit.oak.query.ast.Operator;
import org.apache.jackrabbit.oak.query.ast.OrderingImpl;
import org.apache.jackrabbit.oak.query.ast.PropertyExistenceImpl;
import org.apache.jackrabbit.oak.query.ast.SelectorImpl;
import org.apache.jackrabbit.oak.query.index.FilterImpl;
import org.apache.jackrabbit.oak.spi.query.QueryIndex;

public class FirstImpl
extends DynamicOperandImpl {
    private final DynamicOperandImpl operand;

    public FirstImpl(DynamicOperandImpl operand) {
        this.operand = operand;
    }

    public DynamicOperandImpl getOperand() {
        return this.operand;
    }

    @Override
    boolean accept(AstVisitor v) {
        return v.visit(this);
    }

    public String toString() {
        return "first(" + this.operand + ")";
    }

    @Override
    public PropertyExistenceImpl getPropertyExistence() {
        return this.operand.getPropertyExistence();
    }

    @Override
    public Set<SelectorImpl> getSelectors() {
        return this.operand.getSelectors();
    }

    @Override
    public PropertyValue currentProperty() {
        PropertyValue p = this.operand.currentProperty();
        if (p == null) {
            return null;
        }
        if (p.isArray()) {
            if (p.count() == 0) {
                return null;
            }
            return PropertyValues.newString((String)((String)p.getValue(Type.STRING, 0)));
        }
        return p;
    }

    @Override
    public void restrict(FilterImpl f, Operator operator, PropertyValue v) {
        if (operator == Operator.NOT_EQUAL && v != null) {
            return;
        }
        String fn = this.getFunction(f.getSelector());
        if (fn != null) {
            f.restrictProperty("function*" + fn, operator, v, 1);
        }
    }

    @Override
    public void restrictList(FilterImpl f, List<PropertyValue> list) {
        String fn = this.getFunction(f.getSelector());
        f.restrictPropertyAsList("function*" + fn, list);
    }

    @Override
    public String getFunction(SelectorImpl s) {
        String f = this.operand.getFunction(s);
        if (f == null) {
            return null;
        }
        return "first*" + f;
    }

    @Override
    public boolean canRestrictSelector(SelectorImpl s) {
        return this.operand.canRestrictSelector(s);
    }

    @Override
    int getPropertyType() {
        return 1;
    }

    @Override
    public DynamicOperandImpl createCopy() {
        return new FirstImpl(this.operand.createCopy());
    }

    @Override
    public QueryIndex.OrderEntry getOrderEntry(SelectorImpl s, OrderingImpl o) {
        String fn = this.getFunction(s);
        if (fn != null) {
            return new QueryIndex.OrderEntry("function*" + fn, Type.STRING, o.isDescending() ? QueryIndex.OrderEntry.Order.DESCENDING : QueryIndex.OrderEntry.Order.ASCENDING);
        }
        return null;
    }
}

