/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.whitepages.model;

import java.text.ParseException;
import java.util.Date;
import org.silverpeas.components.whitepages.model.Card;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.contribution.model.SilverpeasContent;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.kernel.logging.SilverLogger;

public class SilverCard
implements SilverpeasContent {
    private static final long serialVersionUID = 28853110916688897L;
    private final String id;
    private final String instanceId;
    private final String creatorId;
    private Date creationDate;
    private final String silverpeasContentId;

    public SilverCard(Card card, int silverContentId) {
        this.id = card.getPK().getId();
        this.instanceId = card.getInstanceId();
        this.creatorId = Integer.toString(card.getCreatorId());
        try {
            this.creationDate = DateUtil.parse((String)card.getCreationDate());
        }
        catch (ParseException ex) {
            SilverLogger.getLogger((Object)this).error(ex.getMessage(), (Throwable)ex);
        }
        this.silverpeasContentId = Integer.toString(silverContentId);
    }

    public String getId() {
        return this.id;
    }

    public String getComponentInstanceId() {
        return this.instanceId;
    }

    public String getSilverpeasContentId() {
        return this.silverpeasContentId;
    }

    public User getCreator() {
        return User.getById((String)this.creatorId);
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public User getLastUpdater() {
        return this.getCreator();
    }

    public Date getLastUpdateDate() {
        return this.getCreationDate();
    }

    public String getTitle() {
        return null;
    }

    public String getDescription() {
        return null;
    }

    public String getContributionType() {
        return null;
    }
}

