/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.kmelia.service;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.transaction.Transactional;
import org.apache.chemistry.opencmis.commons.exceptions.CmisNotSupportedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisPermissionDeniedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisServiceUnavailableException;
import org.silverpeas.components.kmelia.KmeliaPublicationHelper;
import org.silverpeas.components.kmelia.model.KmeliaPublication;
import org.silverpeas.components.kmelia.model.KmeliaRuntimeException;
import org.silverpeas.components.kmelia.service.KmeliaHelper;
import org.silverpeas.components.kmelia.service.KmeliaService;
import org.silverpeas.core.ResourceIdentifier;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.admin.component.model.SilverpeasSharedComponentInstance;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.cmis.CmisContributionsProvider;
import org.silverpeas.core.contribution.model.ContributionIdentifier;
import org.silverpeas.core.contribution.model.CoreContributionType;
import org.silverpeas.core.contribution.model.I18nContribution;
import org.silverpeas.core.contribution.publication.model.PublicationDetail;
import org.silverpeas.core.contribution.publication.model.PublicationPK;
import org.silverpeas.core.node.model.NodeDetail;
import org.silverpeas.core.node.model.NodePK;
import org.silverpeas.core.security.authorization.AccessControlContext;
import org.silverpeas.core.security.authorization.AccessControlOperation;
import org.silverpeas.core.security.authorization.PublicationAccessControl;

@Service
@Named(value="kmeliaContributionsProviderForCMIS")
public class CmisKmeliaContributionsProvider
implements CmisContributionsProvider {
    @Inject
    private KmeliaService kmeliaService;
    @Inject
    private OrganizationController controller;
    @Inject
    private PublicationAccessControl accessControl;

    public List<I18nContribution> getAllowedRootContributions(ResourceIdentifier appId, User user) {
        String kmeliaId = appId.asString();
        this.checkKmeliaAccessible(kmeliaId, user);
        boolean treeEnabled = KmeliaPublicationHelper.isTreeEnabled(kmeliaId);
        NodePK root = new NodePK("0", kmeliaId);
        if (treeEnabled) {
            ContributionIdentifier rootId = ContributionIdentifier.from((ResourceReference)root, (String)"Node");
            return this.getAllowedContributionsInFolder(rootId, user);
        }
        String profile = this.kmeliaService.getUserTopicProfile(root, user.getId());
        return this.kmeliaService.getAuthorizedPublicationsOfFolder(root, profile, user.getId(), false).stream().map(KmeliaPublication::getDetail).collect(Collectors.toList());
    }

    public List<I18nContribution> getAllowedContributionsInFolder(ContributionIdentifier folder, User user) {
        String kmeliaId = folder.getComponentInstanceId();
        this.checkKmeliaAccessible(kmeliaId, user);
        boolean treeEnabled = KmeliaPublicationHelper.isTreeEnabled(kmeliaId);
        NodePK folderPK = this.toNodePK(folder);
        try {
            Stream<Object> publications;
            String profile = this.kmeliaService.getUserTopicProfile(folderPK, user.getId());
            if (!folderPK.isRoot() || KmeliaPublicationHelper.isPublicationsOnRootAllowed(kmeliaId)) {
                List pubsInFolder = this.kmeliaService.getAuthorizedPublicationsOfFolder(folderPK, profile, user.getId(), treeEnabled).stream().filter(Predicate.not(KmeliaPublication::isAlias).and(KmeliaPublication::isVisible)).map(KmeliaPublication::getDetail).collect(Collectors.toList());
                Map<String, PublicationDetail> drafts = this.accessControl.filterAuthorizedByUser(user.getId(), (Collection)pubsInFolder.stream().filter(this::isInDraft).collect(Collectors.toList()), AccessControlContext.init().onOperationsOf(new AccessControlOperation[]{AccessControlOperation.MODIFICATION})).collect(Collectors.toMap(PublicationDetail::getId, p -> {
                    PublicationPK pk = new PublicationPK(p.getCloneId(), p.getInstanceId());
                    return this.kmeliaService.getPublicationDetail(pk);
                }));
                publications = pubsInFolder.stream().map(p -> drafts.getOrDefault(p.getId(), (PublicationDetail)p));
            } else {
                publications = Stream.empty();
            }
            Stream<NodeDetail> subFolders = this.kmeliaService.getFolderChildren(folderPK, user.getId()).stream().filter(n -> !KmeliaHelper.isToValidateFolder(n.getNodePK().getId())).filter(n -> !n.isUnclassified() && !n.isBin() && !n.getId().equals("notvisibleContributions"));
            return Stream.concat(publications, subFolders).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new CmisObjectNotFoundException(e.getMessage());
        }
    }

    public I18nContribution getContribution(ContributionIdentifier contributionId, User user) {
        if (contributionId.getType().equals("Node")) {
            return this.getNodeDetail(contributionId, user);
        }
        if (contributionId.getType().equals("Publication")) {
            return this.getPublicationDetail(contributionId, user);
        }
        throw new CmisNotSupportedException("Don't support such contribution types " + contributionId.getType());
    }

    @Transactional
    public I18nContribution createContribution(I18nContribution contribution, ResourceIdentifier appId, String language) {
        User user = User.getCurrentRequester();
        String kmeliaId = appId.asString();
        this.checkKmeliaAccessible(kmeliaId, user);
        ContributionIdentifier rootFolder = ContributionIdentifier.from((String)kmeliaId, (String)"0", (CoreContributionType)CoreContributionType.NODE);
        return this.createContributionInFolder(contribution, rootFolder, language);
    }

    @Transactional
    public I18nContribution createContributionInFolder(I18nContribution contribution, ContributionIdentifier folder, String language) {
        if (contribution.getIdentifier().getType().equals("Publication")) {
            PublicationDetail publication = this.toPublicationDetail(contribution, language);
            String id = this.kmeliaService.createPublicationIntoTopic(publication, this.toNodePK(folder));
            PublicationDetail saved = publication.copy();
            saved.setPk(new PublicationPK(id, publication.getInstanceId()));
            return publication;
        }
        throw new CmisNotSupportedException(String.format("CMIS creation of %s isn't yet supported in Kmelia", contribution.getContributionType()));
    }

    private NodePK toNodePK(ContributionIdentifier identifier) {
        return new NodePK(identifier.getLocalId(), identifier.getComponentInstanceId());
    }

    private PublicationPK toPublicationPK(ContributionIdentifier identifier) {
        return new PublicationPK(identifier.getLocalId(), identifier.getComponentInstanceId());
    }

    private PublicationDetail toPublicationDetail(I18nContribution contribution, String language) {
        PublicationDetail publication;
        if (contribution instanceof PublicationDetail) {
            publication = (PublicationDetail)contribution;
        } else {
            PublicationPK pk = new PublicationPK(contribution.getIdentifier().getLocalId(), contribution.getIdentifier().getComponentInstanceId());
            publication = PublicationDetail.builder((String)language).setPk(pk).setNameAndDescription(contribution.getName(), contribution.getDescription()).setImportance(1).created(contribution.getCreationDate(), contribution.getCreator().getId()).updated(contribution.getLastUpdateDate(), contribution.getLastUpdater().getId()).build();
        }
        return publication;
    }

    private void checkKmeliaAccessible(String kmeliaId, User user) {
        if (this.controller.getComponentInstance(kmeliaId).filter(SilverpeasSharedComponentInstance.class::isInstance).map(SilverpeasSharedComponentInstance.class::cast).filter(i -> i.getName().equals("kmelia") && i.canBeAccessedBy(user)).isEmpty()) {
            throw new CmisObjectNotFoundException(String.format("The application %s doesn't exist or is not accessible to user %s", kmeliaId, user.getId()));
        }
    }

    private boolean isInDraft(PublicationDetail publication) {
        return publication.isValid() && publication.haveGotClone() && !publication.isClone();
    }

    private NodeDetail getNodeDetail(ContributionIdentifier id, User user) {
        NodeDetail node;
        try {
            node = this.kmeliaService.getNodeHeader(id.getLocalId(), id.getComponentInstanceId());
            if (node == null) {
                throw new KmeliaRuntimeException("");
            }
        }
        catch (Exception e) {
            throw new CmisObjectNotFoundException(String.format("Folder %s not found!", id.asString()));
        }
        if (node.isBin() || node.isUnclassified() || KmeliaHelper.isToValidateFolder(node.getId()) || node.getId().equals("notvisibleContributions")) {
            throw new CmisPermissionDeniedException("Forbidden access to special folders!");
        }
        if (!node.canBeAccessedBy(user)) {
            throw new CmisPermissionDeniedException("Forbidden access to folder " + id.asString());
        }
        return node;
    }

    private PublicationDetail getPublicationDetail(ContributionIdentifier id, User user) {
        try {
            PublicationDetail publication = this.kmeliaService.getPublicationDetail(this.toPublicationPK(id));
            if (publication == null) {
                throw new CmisObjectNotFoundException(String.format("Publication %s not found!", id.asString()));
            }
            if (!publication.canBeAccessedBy(user)) {
                throw new CmisPermissionDeniedException("Forbidden access to publication " + id.asString());
            }
            if (this.isInDraft(publication) && this.accessControl.isUserAuthorized(user.getId(), publication, AccessControlContext.init().onOperationsOf(new AccessControlOperation[]{AccessControlOperation.MODIFICATION}))) {
                PublicationPK pk = new PublicationPK(publication.getCloneId(), publication.getInstanceId());
                return this.kmeliaService.getPublicationDetail(pk);
            }
            return publication;
        }
        catch (Exception e) {
            throw new CmisServiceUnavailableException(e.getMessage());
        }
    }
}

