/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.standby.server;

import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.jackrabbit.oak.segment.RecordId;
import org.apache.jackrabbit.oak.segment.file.FileStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileStoreUtil {
    private static final Logger log = LoggerFactory.getLogger(FileStoreUtil.class);
    private static final long DEFAULT_SLEEP_TIME = 125L;

    private FileStoreUtil() {
    }

    public static int roundDiv(long x, int y) {
        return (int)Math.ceil((double)x / (double)y);
    }

    static RecordId readPersistedHeadWithRetry(FileStore store, long timeout) {
        Supplier<RecordId> headSupplier = () -> store.getRevisions().getPersistedHead();
        if (timeout > 125L) {
            return FileStoreUtil.readWithRetry(headSupplier, "persisted head", timeout);
        }
        return headSupplier.get();
    }

    private static <T> T readWithRetry(Supplier<T> supplier, String supplied, long timeout) {
        int i = 0;
        while ((long)i < timeout / 125L) {
            if (supplier.get() != null) {
                return supplier.get();
            }
            try {
                log.trace("Unable to read {}, waiting...", (Object)supplied);
                TimeUnit.MILLISECONDS.sleep(125L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return null;
            }
            ++i;
        }
        return null;
    }
}

