/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.query.ast;

import java.util.Collections;
import java.util.Set;
import org.apache.jackrabbit.oak.query.ast.AstElement;
import org.apache.jackrabbit.oak.query.ast.AstVisitor;
import org.apache.jackrabbit.oak.query.ast.ConstraintImpl;
import org.apache.jackrabbit.oak.query.ast.Operator;
import org.apache.jackrabbit.oak.query.ast.SelectorImpl;
import org.apache.jackrabbit.oak.query.ast.SourceImpl;
import org.apache.jackrabbit.oak.query.index.FilterImpl;

public class PropertyExistenceImpl
extends ConstraintImpl {
    private final String selectorName;
    private final String propertyName;
    private SelectorImpl selector;

    public PropertyExistenceImpl(SelectorImpl selector, String selectorName, String propertyName) {
        this.selector = selector;
        this.selectorName = selectorName;
        this.propertyName = propertyName;
    }

    public PropertyExistenceImpl(String selectorName, String propertyName) {
        this.selectorName = selectorName;
        this.propertyName = propertyName;
    }

    @Override
    public boolean evaluate() {
        return this.selector.currentProperty(this.propertyName) != null;
    }

    @Override
    public Set<PropertyExistenceImpl> getPropertyExistenceConditions() {
        return Collections.singleton(this);
    }

    @Override
    public Set<SelectorImpl> getSelectors() {
        return Collections.singleton(this.selector);
    }

    @Override
    boolean accept(AstVisitor v) {
        return v.visit(this);
    }

    public String toString() {
        return this.quote(this.selectorName) + "." + this.quote(this.propertyName) + " is not null";
    }

    public void bindSelector(SourceImpl source) {
        this.selector = source.getExistingSelector(this.selectorName);
    }

    @Override
    public void restrict(FilterImpl f) {
        if (f.getSelector().equals(this.selector)) {
            String pn = this.normalizePropertyName(this.propertyName);
            f.restrictProperty(pn, Operator.NOT_EQUAL, null);
        }
    }

    @Override
    public void restrictPushDown(SelectorImpl s) {
        if (s.equals(this.selector)) {
            s.restrictSelector(this);
        }
    }

    @Override
    public int hashCode() {
        String pn = this.normalizePropertyName(this.propertyName);
        return (this.selectorName == null ? 0 : this.selectorName.hashCode()) * 31 + (pn == null ? 0 : pn.hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PropertyExistenceImpl other = (PropertyExistenceImpl)obj;
        if (!PropertyExistenceImpl.equalsStrings(this.selectorName, other.selectorName)) {
            return false;
        }
        String pn = this.normalizePropertyName(this.propertyName);
        String pn2 = this.normalizePropertyName(other.propertyName);
        return PropertyExistenceImpl.equalsStrings(pn, pn2);
    }

    private static boolean equalsStrings(String a, String b) {
        return a == null || b == null ? a == b : a.equals(b);
    }

    @Override
    public AstElement copyOf() {
        return new PropertyExistenceImpl(this.selectorName, this.propertyName);
    }
}

