/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.blob.serializer;

import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.json.Base64BlobSerializer;
import org.apache.jackrabbit.oak.json.BlobDeserializer;
import org.apache.jackrabbit.oak.json.BlobSerializer;
import org.apache.jackrabbit.oak.plugins.blob.BlobStoreBlob;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;

public class BlobIdSerializer
extends BlobSerializer
implements BlobDeserializer {
    private static final String PREFIX = "0y";
    private final Base64BlobSerializer base64 = new Base64BlobSerializer();
    private final BlobStore blobStore;

    public BlobIdSerializer(BlobStore blobStore) {
        this.blobStore = blobStore;
    }

    public String serialize(Blob blob) {
        String blobId = blob.getContentIdentity();
        if (blobId != null) {
            return blobId;
        }
        return this.encode(blob);
    }

    public Blob deserialize(String value) {
        if (value.startsWith(PREFIX)) {
            return this.base64.deserialize(value.substring(PREFIX.length()));
        }
        return new BlobStoreBlob(this.blobStore, value);
    }

    private String encode(Blob blob) {
        return PREFIX + this.base64.serialize(blob);
    }
}

