/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.yellowpages;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.inject.Named;
import org.silverpeas.components.yellowpages.model.TopicDetail;
import org.silverpeas.components.yellowpages.model.UserContact;
import org.silverpeas.components.yellowpages.service.YellowpagesService;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.admin.service.OrganizationControllerProvider;
import org.silverpeas.core.annotation.Provider;
import org.silverpeas.core.contact.model.ContactDetail;
import org.silverpeas.core.node.model.NodePK;
import org.silverpeas.core.node.service.NodeService;
import org.silverpeas.core.silverstatistics.volume.model.UserIdCountVolumeCouple;
import org.silverpeas.core.silverstatistics.volume.service.ComponentStatisticsProvider;

@Provider
@Named(value="yellowpagesStatistics")
public class YellowpagesStatistics
implements ComponentStatisticsProvider {
    private static final String USELESS = "useless";
    private NodeService nodeService = NodeService.get();

    public Collection<UserIdCountVolumeCouple> getVolume(String spaceId, String componentId) {
        Collection nodes = this.getNodeService().getAllNodes(new NodePK(USELESS, componentId));
        ArrayList<UserIdCountVolumeCouple> myArrayList = new ArrayList<UserIdCountVolumeCouple>(nodes.size());
        if (!nodes.isEmpty()) {
            Collection<UserContact> c = this.getContacts("0", componentId);
            for (UserContact contact : c) {
                ContactDetail detail = contact.getContact();
                UserIdCountVolumeCouple myCouple = new UserIdCountVolumeCouple();
                myCouple.setUserId(detail.getCreatorId());
                myCouple.setCountVolume(1L);
                myArrayList.add(myCouple);
            }
        }
        return myArrayList;
    }

    private YellowpagesService getYellowPagesService() {
        return YellowpagesService.get();
    }

    private Collection<UserContact> getContacts(String topicId, String componentId) {
        ArrayList<UserContact> result = new ArrayList<UserContact>();
        if (topicId == null) {
            return result;
        }
        OrganizationController organisationController = OrganizationControllerProvider.getOrganisationController();
        if (topicId.startsWith("group_")) {
            int nbUsers = organisationController.getAllSubUsersNumber(topicId.substring("group_".length()));
            for (int n2 = 0; n2 < nbUsers; ++n2) {
                ContactDetail detail = new ContactDetail(USELESS, USELESS, USELESS, USELESS, USELESS, USELESS, USELESS, new Date(), "0");
                UserContact contact = new UserContact();
                contact.setContact(detail);
                result.add(contact);
            }
        } else {
            TopicDetail topic;
            try {
                topic = this.getYellowPagesService().goTo(new NodePK(topicId, componentId), "0");
                if (topic != null) {
                    result.addAll(topic.getContactDetails());
                }
            }
            catch (Exception ex) {
                topic = null;
            }
            if (topic != null) {
                topic.getNodeDetail().getChildrenDetails().stream().filter(n -> !n.getNodePK().isRoot() && !n.getNodePK().isTrash() && !n.getNodePK().isUnclassed()).forEach(n -> result.addAll(this.getContacts(n.getNodePK().getId(), componentId)));
            }
        }
        return result;
    }

    private NodeService getNodeService() {
        return this.nodeService;
    }
}

