/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.swe.commons.jaxrs.utilities;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import edu.psu.swe.commons.jaxrs.server.ObjectMapperContextResolver;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Optional;

public class JsonSerializationUtil {
    private static final ObjectMapper mapper;

    public static Optional<String> serialize(Object obj) throws IOException {
        if (obj == null) {
            return Optional.empty();
        }
        StringWriter writer = new StringWriter();
        mapper.writeValue((Writer)writer, obj);
        return Optional.ofNullable(writer.toString());
    }

    public static <T> Optional<T> deserialize(String json, Class<T> clazz) throws IOException {
        if (json == null || json.trim().isEmpty()) {
            return Optional.empty();
        }
        Object obj = mapper.readValue(json, clazz);
        return Optional.of(obj);
    }

    public static <T> Optional<List<T>> deserializeList(String json, Class<T> clazz) throws IOException {
        if (json == null || json.trim().isEmpty()) {
            return Optional.empty();
        }
        CollectionType type = mapper.getTypeFactory().constructCollectionType(List.class, clazz);
        List list = (List)mapper.readValue(json, (JavaType)type);
        if (list.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(list);
    }

    static {
        ObjectMapperContextResolver resolver = new ObjectMapperContextResolver();
        mapper = resolver.getContext(null);
    }
}

