/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.infoletter;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.silverpeas.components.infoletter.model.InfoLetterPublicationPdC;
import org.silverpeas.components.infoletter.model.InfoLetterService;
import org.silverpeas.components.infoletter.service.InfoLetterServiceProvider;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.WAPrimaryKey;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.contribution.contentcontainer.content.AbstractSilverpeasContentManager;
import org.silverpeas.core.contribution.contentcontainer.content.SilverContentVisibility;
import org.silverpeas.core.contribution.model.Contribution;
import org.silverpeas.core.persistence.jdbc.bean.IdPK;

@Service
public class InfoLetterContentManager
extends AbstractSilverpeasContentManager {
    private static final String CONTENT_ICON_FILE_NAME = "infoLetterSmall.gif";

    protected InfoLetterContentManager() {
    }

    protected String getContentIconFileName(String componentInstanceId) {
        return CONTENT_ICON_FILE_NAME;
    }

    protected Optional<Contribution> getContribution(String resourceId, String componentInstanceId) {
        return Optional.ofNullable(this.getInfoLetterPublicationPdC(resourceId, componentInstanceId));
    }

    protected List<Contribution> getAccessibleContributions(List<ResourceReference> resourceReferences, String currentUserId) {
        return resourceReferences.stream().map(r -> this.getInfoLetterPublicationPdC(r.getLocalId(), r.getComponentInstanceId())).collect(Collectors.toList());
    }

    protected <T extends Contribution> SilverContentVisibility computeSilverContentVisibility(T contribution) {
        InfoLetterPublicationPdC ilPub = (InfoLetterPublicationPdC)contribution;
        return new SilverContentVisibility(this.isVisible(ilPub));
    }

    private boolean isVisible(InfoLetterPublicationPdC ilPub) {
        return ilPub.getPublicationState() == 2;
    }

    private Contribution getInfoLetterPublicationPdC(String resourceId, String componentId) {
        InfoLetterPublicationPdC ilPub = this.getDataInterface().getInfoLetterPublication((WAPrimaryKey)new IdPK(resourceId));
        ilPub.setInstanceId(componentId);
        return ilPub;
    }

    private InfoLetterService getDataInterface() {
        return InfoLetterServiceProvider.getInfoLetterData();
    }
}

