/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.gallery.notification.user;

import java.lang.annotation.Annotation;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.silverpeas.components.gallery.model.AlbumDetail;
import org.silverpeas.components.gallery.model.AlbumMedia;
import org.silverpeas.components.gallery.model.Media;
import org.silverpeas.components.gallery.notification.user.GalleryAlbumMediaSubscriptionNotificationBuilder;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.notification.user.builder.UserNotificationBuilder;
import org.silverpeas.core.notification.user.builder.helper.UserNotificationHelper;
import org.silverpeas.core.scheduler.Job;
import org.silverpeas.core.scheduler.JobExecutionContext;
import org.silverpeas.core.scheduler.Scheduler;
import org.silverpeas.core.scheduler.SchedulerException;
import org.silverpeas.core.scheduler.SchedulerProvider;
import org.silverpeas.core.scheduler.trigger.JobTrigger;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.logging.SilverLogger;

@Service
public class AlbumMediaNotificationManager {
    private static final ConcurrentMap<String, NotificationAlbumJob> contextCache = new ConcurrentHashMap<String, NotificationAlbumJob>();

    AlbumMediaNotificationManager() {
    }

    private static String buildKey(User user, AlbumMedia albumMedia) {
        return AlbumMediaNotificationManager.buildKey(user, albumMedia.getMedia().getInstanceId(), albumMedia.getAlbumId());
    }

    private static String buildKey(User user, String instanceId, String albumId) {
        return user.getId() + "@" + instanceId + "@" + albumId;
    }

    public static AlbumMediaNotificationManager get() {
        return (AlbumMediaNotificationManager)ServiceProvider.getService(AlbumMediaNotificationManager.class, (Annotation[])new Annotation[0]);
    }

    public void putCreationOf(AlbumMedia albumMedia, User by) {
        NotificationAlbumJob job = this.getNotificationAlbumJob(by, albumMedia);
        job.registerCreation(albumMedia.getMedia());
    }

    public void putDeletionOf(AlbumMedia albumMedia, User by) {
        NotificationAlbumJob job = this.getNotificationAlbumJob(by, albumMedia);
        job.registerDeletion(albumMedia.getMedia());
    }

    private NotificationAlbumJob getNotificationAlbumJob(User user, AlbumMedia albumMedia) {
        String key = AlbumMediaNotificationManager.buildKey(user, albumMedia);
        return contextCache.computeIfAbsent(key, k -> new NotificationAlbumJob(user, albumMedia.getAlbum()));
    }

    static class NotificationAlbumJob
    extends Job {
        final Set<Media> creations;
        final User sender;
        final String instanceId;
        final AlbumDetail album;
        private final Object mutex;

        private NotificationAlbumJob(User sender, AlbumDetail album) {
            super("JOB_NAME_" + UUID.randomUUID().toString());
            this.mutex = this.creations = Collections.synchronizedSet(new HashSet());
            this.sender = sender;
            this.instanceId = album.getNodePK().getInstanceId();
            this.album = album;
        }

        private void setJobDelay() {
            boolean sendImmediately;
            SettingBundle settings = ResourceLocator.getSettingBundle((String)"org.silverpeas.gallery.settings.gallerySettings");
            int delayInSeconds = settings.getInteger("subscription.notification.delay", 180);
            boolean bl = sendImmediately = delayInSeconds <= 0;
            if (!sendImmediately) {
                Scheduler scheduler = SchedulerProvider.getVolatileScheduler();
                OffsetDateTime executionTime = OffsetDateTime.now().plusSeconds(delayInSeconds);
                try {
                    scheduler.unscheduleJob(this.getName());
                    if (this.isMediaToProcess()) {
                        scheduler.scheduleJob((Job)this, JobTrigger.triggerAt((OffsetDateTime)executionTime));
                    } else {
                        this.clearJobCache();
                    }
                }
                catch (SchedulerException e) {
                    SilverLogger.getLogger((Object)((Object)this)).error((Throwable)e);
                    sendImmediately = true;
                }
            }
            if (sendImmediately) {
                this.execute(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void registerCreation(Media media) {
            Object object = this.mutex;
            synchronized (object) {
                this.creations.add(media);
                this.setJobDelay();
            }
            this.putIntoCache();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void registerDeletion(Media media) {
            Object object = this.mutex;
            synchronized (object) {
                this.creations.remove(media);
                this.setJobDelay();
            }
            this.putIntoCache();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(JobExecutionContext context) {
            Media[] creationsToProcess;
            this.clearJobCache();
            Object object = this.mutex;
            synchronized (object) {
                creationsToProcess = this.creations.toArray(new Media[0]);
                this.creations.clear();
            }
            if (creationsToProcess.length > 0) {
                GalleryAlbumMediaSubscriptionNotificationBuilder builder = new GalleryAlbumMediaSubscriptionNotificationBuilder(this.album, this.sender).aboutMedia(creationsToProcess);
                UserNotificationHelper.buildAndSend((UserNotificationBuilder)builder);
            }
        }

        private void clearJobCache() {
            String cacheKey = AlbumMediaNotificationManager.buildKey(this.sender, this.instanceId, this.album.getId());
            contextCache.remove(cacheKey);
        }

        private boolean isMediaToProcess() {
            return !this.creations.isEmpty();
        }

        private void putIntoCache() {
            if (this.isMediaToProcess()) {
                contextCache.put(AlbumMediaNotificationManager.buildKey(this.sender, this.instanceId, this.album.getId()), this);
            }
        }
    }
}

