/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.community.repository;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.persistence.Query;
import org.silverpeas.components.community.model.CommunityMembership;
import org.silverpeas.components.community.model.CommunityOfUsers;
import org.silverpeas.components.community.model.MembershipStatus;
import org.silverpeas.components.community.repository.CommunityMembershipRepository;
import org.silverpeas.core.admin.PaginationPage;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.annotation.Repository;
import org.silverpeas.core.persistence.datasource.repository.PaginationCriterion;
import org.silverpeas.core.persistence.datasource.repository.jpa.NamedParameters;
import org.silverpeas.core.persistence.datasource.repository.jpa.SilverpeasJpaEntityRepository;
import org.silverpeas.core.util.SilverpeasList;

@Repository
public class CommunityMembershipJpaRepository
extends SilverpeasJpaEntityRepository<CommunityMembership>
implements CommunityMembershipRepository {
    private static final String COMMUNITY_FIELD = "community";
    private static final String STATUS = "status";
    private static final String SELECT_MEMBER = "select m from " + CommunityMembership.class.getSimpleName() + " m ";

    @Override
    public CommunityMembershipRepository.CommunityMembershipsTable getMembershipsTable(CommunityOfUsers community) {
        return new CommunityMembershipsTableImpl(community);
    }

    @Override
    public long deleteByComponentInstanceId(String componentInstanceId) {
        Query deleteQuery = this.getEntityManager().createQuery("delete from CommunityMembership m where m.community in (select c from CommunityOfUsers c where c.componentInstanceId = :id)");
        return this.newNamedParameters().add("id", (Object)componentInstanceId).applyTo(deleteQuery).executeUpdate();
    }

    private class CommunityMembershipsTableImpl
    implements CommunityMembershipRepository.CommunityMembershipsTable {
        private final CommunityOfUsers community;

        public CommunityMembershipsTableImpl(CommunityOfUsers community) {
            this.community = community;
        }

        @Override
        public void deleteAll() {
            Query deleteQuery = CommunityMembershipJpaRepository.this.getEntityManager().createQuery("delete from CommunityMembership m where m.community = :community");
            CommunityMembershipJpaRepository.this.newNamedParameters().add(CommunityMembershipJpaRepository.COMMUNITY_FIELD, (Object)this.community).applyTo(deleteQuery).executeUpdate();
        }

        @Override
        public Optional<CommunityMembership> getByUser(User user) {
            NamedParameters parameters = CommunityMembershipJpaRepository.this.newNamedParameters().add("userId", (Object)Integer.valueOf(user.getId())).add(CommunityMembershipJpaRepository.COMMUNITY_FIELD, (Object)this.community);
            return Optional.ofNullable((CommunityMembership)CommunityMembershipJpaRepository.this.findFirstByNamedQuery("byUserIdAndByCommunity", parameters));
        }

        @Override
        public SilverpeasList<CommunityMembership> getPending(@Nullable PaginationPage page) {
            NamedParameters parameters = CommunityMembershipJpaRepository.this.newNamedParameters().add(CommunityMembershipJpaRepository.COMMUNITY_FIELD, (Object)this.community).add(CommunityMembershipJpaRepository.STATUS, (Object)MembershipStatus.PENDING);
            String query = SELECT_MEMBER + "where m.community = :community and status = :status order by m.lastUpdateDate DESC";
            PaginationCriterion pagination = page == null ? PaginationCriterion.NO_PAGINATION : page.asCriterion();
            return CommunityMembershipJpaRepository.this.listFromJpqlString(query, parameters, pagination, CommunityMembership.class);
        }

        @Override
        public SilverpeasList<CommunityMembership> getMembers(@Nonnull PaginationPage page) {
            Objects.requireNonNull(page);
            NamedParameters parameters = CommunityMembershipJpaRepository.this.newNamedParameters().add(CommunityMembershipJpaRepository.COMMUNITY_FIELD, (Object)this.community).add(CommunityMembershipJpaRepository.STATUS, (Object)MembershipStatus.COMMITTED);
            return CommunityMembershipJpaRepository.this.listFromJpqlString(SELECT_MEMBER + "where m.status = :status and m.community = :community order by m.lastUpdateDate DESC", parameters, page.asCriterion());
        }

        @Override
        public SilverpeasList<CommunityMembership> getAll(@Nonnull PaginationPage page) {
            Objects.requireNonNull(page);
            NamedParameters parameters = CommunityMembershipJpaRepository.this.newNamedParameters().add(CommunityMembershipJpaRepository.COMMUNITY_FIELD, (Object)this.community);
            return CommunityMembershipJpaRepository.this.listFromJpqlString(SELECT_MEMBER + "where m.community = :community order by m.lastUpdateDate DESC", parameters, page.asCriterion());
        }

        @Override
        public List<CommunityMembership> getAllMembers() {
            NamedParameters parameters = CommunityMembershipJpaRepository.this.newNamedParameters().add(CommunityMembershipJpaRepository.COMMUNITY_FIELD, (Object)this.community);
            return CommunityMembershipJpaRepository.this.findByNamedQuery("allNonRemoved", parameters);
        }

        @Override
        public boolean isEmpty() {
            Query countQuery = CommunityMembershipJpaRepository.this.getEntityManager().createQuery("select count(m) from CommunityMembership m where m.community = :community");
            long count = (Long)CommunityMembershipJpaRepository.this.newNamedParameters().add(CommunityMembershipJpaRepository.COMMUNITY_FIELD, (Object)this.community).applyTo(countQuery).getSingleResult();
            return count == 0L;
        }
    }
}

