/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.xml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.spi.xml.TextValue;
import org.apache.jackrabbit.util.Base64;

class StringValue
implements TextValue {
    private final String value;
    private final ValueFactory valueFactory;
    private final NamePathMapper namePathMapper;

    protected StringValue(String value, ValueFactory valueFactory, NamePathMapper namePathMapper) {
        this.value = value;
        this.valueFactory = valueFactory;
        this.namePathMapper = namePathMapper;
    }

    public String getString() {
        return this.value;
    }

    public Value getValue(int type) throws RepositoryException {
        if (type == 2) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                Base64.decode((String)this.value, (OutputStream)baos);
                return this.valueFactory.createValue((InputStream)new ByteArrayInputStream(baos.toByteArray()));
            }
            catch (IOException e) {
                throw new RepositoryException("Failed to decode binary value: " + this.value, (Throwable)e);
            }
        }
        String jcrValue = type == 7 ? this.namePathMapper.getOakName(this.value) : (type == 8 ? this.namePathMapper.getOakPath(this.value) : this.value);
        return this.valueFactory.createValue(jcrValue, type);
    }

    public void dispose() {
    }
}

