/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.composite;

import java.util.Iterator;
import java.util.function.Supplier;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.plugins.tree.TreeProvider;
import org.apache.jackrabbit.oak.plugins.tree.TreeType;
import org.apache.jackrabbit.oak.plugins.tree.TreeTypeProvider;
import org.apache.jackrabbit.oak.security.authorization.composite.CompositeAuthorizationConfiguration;
import org.apache.jackrabbit.oak.security.authorization.composite.Util;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.AggregatedPermissionProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.Permissions;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.TreePermission;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class CompositeTreePermission
implements TreePermission {
    private final Tree tree;
    private final TreeType type;
    private final TreeProvider treeProvider;
    private final TreeTypeProvider typeProvider;
    private final AggregatedPermissionProvider[] providers;
    private final TreePermission[] treePermissions;
    private final int childSize;
    private Boolean canRead;
    private Boolean canReadProperties;

    private CompositeTreePermission(@NotNull Tree tree, @NotNull TreeType type, @NotNull TreeProvider treeProvider, @NotNull TreeTypeProvider typeProvider, @NotNull AggregatedPermissionProvider[] providers, @NotNull TreePermission[] treePermissions, int cnt) {
        this.tree = tree;
        this.type = type;
        this.treeProvider = treeProvider;
        this.typeProvider = typeProvider;
        this.providers = providers;
        this.treePermissions = treePermissions;
        this.childSize = providers.length - cnt;
    }

    static TreePermission create(@NotNull Tree rootTree, @NotNull TreeProvider treeProvider, @NotNull TreeTypeProvider typeProvider, @NotNull AggregatedPermissionProvider[] providers, @NotNull CompositeAuthorizationConfiguration.CompositionType compositionType) {
        switch (providers.length) {
            case 0: {
                return TreePermission.EMPTY;
            }
            case 1: {
                return providers[0].getTreePermission(rootTree, TreeType.DEFAULT, TreePermission.EMPTY);
            }
        }
        int cnt = 0;
        TreePermission[] treePermissions = new TreePermission[providers.length];
        for (int i = 0; i < providers.length; ++i) {
            TreePermission tp = providers[i].getTreePermission(rootTree, TreeType.DEFAULT, TreePermission.EMPTY);
            if (!CompositeTreePermission.isValid(tp)) {
                ++cnt;
            }
            treePermissions[i] = tp;
        }
        if (compositionType == CompositeAuthorizationConfiguration.CompositionType.AND) {
            return new CompositeTreePermissionAnd(rootTree, TreeType.DEFAULT, treeProvider, typeProvider, providers, treePermissions, cnt);
        }
        return new CompositeTreePermissionOr(rootTree, TreeType.DEFAULT, treeProvider, typeProvider, providers, treePermissions, cnt);
    }

    static TreePermission create(@NotNull Tree tree, @NotNull TreeProvider treeProvider, @NotNull CompositeTreePermission parentPermission) {
        return CompositeTreePermission.create(() -> tree, tree.getName(), treeProvider.asNodeState(tree), parentPermission, null);
    }

    static TreePermission create(@NotNull Tree tree, @NotNull TreeProvider treeProvider, @NotNull CompositeTreePermission parentPermission, @Nullable TreeType treeType) {
        return CompositeTreePermission.create(() -> tree, tree.getName(), treeProvider.asNodeState(tree), parentPermission, treeType);
    }

    private static TreePermission create(@NotNull Supplier<Tree> lazyTree, @NotNull String childName, @NotNull NodeState childState, @NotNull CompositeTreePermission parentPermission, @Nullable TreeType treeType) {
        switch (parentPermission.childSize) {
            case 0: {
                return TreePermission.EMPTY;
            }
            case 1: {
                TreePermission parent = null;
                for (TreePermission tp : parentPermission.treePermissions) {
                    if (!CompositeTreePermission.isValid(tp)) continue;
                    parent = tp;
                    break;
                }
                return parent == null ? TreePermission.EMPTY : parent.getChildPermission(childName, childState);
            }
        }
        Tree tree = lazyTree.get();
        TreeType type = treeType != null ? treeType : CompositeTreePermission.getType(tree, parentPermission);
        AggregatedPermissionProvider[] pvds = new AggregatedPermissionProvider[parentPermission.childSize];
        TreePermission[] tps = new TreePermission[parentPermission.childSize];
        int cnt = 0;
        int j = 0;
        for (int i = 0; i < parentPermission.providers.length; ++i) {
            TreePermission parent = parentPermission.treePermissions[i];
            if (!CompositeTreePermission.isValid(parent)) continue;
            AggregatedPermissionProvider provider = parentPermission.providers[i];
            TreePermission tp = provider.getTreePermission(tree, type, parent);
            if (!CompositeTreePermission.isValid(tp)) {
                ++cnt;
            }
            tps[j] = tp;
            pvds[j] = provider;
            ++j;
        }
        if (parentPermission.getCompositionType() == CompositeAuthorizationConfiguration.CompositionType.AND) {
            return new CompositeTreePermissionAnd(tree, type, parentPermission.treeProvider, parentPermission.typeProvider, pvds, tps, cnt);
        }
        return new CompositeTreePermissionOr(tree, type, parentPermission.treeProvider, parentPermission.typeProvider, pvds, tps, cnt);
    }

    @NotNull
    public TreePermission getChildPermission(@NotNull String childName, @NotNull NodeState childState) {
        return CompositeTreePermission.create(() -> this.treeProvider.createReadOnlyTree(this.tree, childName, childState), childName, childState, this, null);
    }

    public boolean canRead() {
        if (this.canRead == null) {
            this.canRead = this.grantsRead(null);
        }
        return this.canRead;
    }

    public boolean canRead(@NotNull PropertyState property) {
        return this.grantsRead(property);
    }

    public boolean canReadAll() {
        return false;
    }

    public boolean canReadProperties() {
        if (this.canReadProperties == null) {
            this.canReadProperties = this.grantsReadProperties();
        }
        return this.canReadProperties;
    }

    public boolean isGranted(long permissions) {
        return this.grantsPermission(permissions, null);
    }

    public boolean isGranted(long permissions, @NotNull PropertyState property) {
        return this.grantsPermission(permissions, property);
    }

    @NotNull
    abstract CompositeAuthorizationConfiguration.CompositionType getCompositionType();

    abstract boolean grantsPermission(long var1, @Nullable PropertyState var3);

    abstract boolean grantsRead(@Nullable PropertyState var1);

    abstract boolean grantsReadProperties();

    int length() {
        return this.providers.length;
    }

    @NotNull
    AggregatedPermissionProvider provider(int index) {
        return this.providers[index];
    }

    @NotNull
    TreePermission treePermission(int index) {
        return this.treePermissions[index];
    }

    private static boolean isValid(@NotNull TreePermission tp) {
        return NO_RECOURSE != tp;
    }

    private static TreeType getType(@NotNull Tree tree, @NotNull CompositeTreePermission parent) {
        return parent.typeProvider.getType(tree, parent.type);
    }

    private static final class CompositeTreePermissionAnd
    extends CompositeTreePermission {
        private CompositeTreePermissionAnd(@NotNull Tree tree, @NotNull TreeType type, @NotNull TreeProvider treeProvider, @NotNull TreeTypeProvider typeProvider, @NotNull AggregatedPermissionProvider[] providers, @NotNull TreePermission[] treePermissions, int cnt) {
            super(tree, type, treeProvider, typeProvider, providers, treePermissions, cnt);
        }

        @Override
        @NotNull
        CompositeAuthorizationConfiguration.CompositionType getCompositionType() {
            return CompositeAuthorizationConfiguration.CompositionType.AND;
        }

        @Override
        boolean grantsPermission(long permissions, @Nullable PropertyState property) {
            boolean isGranted = false;
            long coveredPermissions = 0L;
            for (int i = 0; i < this.length(); ++i) {
                TreePermission tp = this.treePermission(i);
                long supported = this.provider(i).supportedPermissions(tp, property, permissions);
                if (!Util.doEvaluate(supported)) continue;
                boolean bl = isGranted = property == null ? tp.isGranted(supported) : tp.isGranted(supported, property);
                if (!isGranted) {
                    return false;
                }
                coveredPermissions |= supported;
            }
            return isGranted && coveredPermissions == permissions;
        }

        @Override
        boolean grantsRead(@Nullable PropertyState property) {
            if (property != null && this.canReadProperties()) {
                return true;
            }
            boolean readable = false;
            for (int i = 0; i < this.length(); ++i) {
                TreePermission tp = this.treePermission(i);
                long supported = this.provider(i).supportedPermissions(tp, property, property == null ? 1L : 2L);
                if (!Util.doEvaluate(supported)) continue;
                boolean bl = readable = property == null ? tp.canRead() : tp.canRead(property);
                if (readable) continue;
                return false;
            }
            return readable;
        }

        @Override
        boolean grantsReadProperties() {
            boolean readable = false;
            for (int i = 0; i < this.length(); ++i) {
                TreePermission tp = this.treePermission(i);
                long supported = this.provider(i).supportedPermissions(tp, null, 2L);
                if (Util.doEvaluate(supported) && !(readable = tp.canReadProperties())) break;
            }
            return readable;
        }
    }

    private static final class CompositeTreePermissionOr
    extends CompositeTreePermission {
        private CompositeTreePermissionOr(@NotNull Tree tree, @NotNull TreeType type, @NotNull TreeProvider treeProvider, @NotNull TreeTypeProvider typeProvider, @NotNull AggregatedPermissionProvider[] providers, @NotNull TreePermission[] treePermissions, int cnt) {
            super(tree, type, treeProvider, typeProvider, providers, treePermissions, cnt);
        }

        @Override
        @NotNull
        CompositeAuthorizationConfiguration.CompositionType getCompositionType() {
            return CompositeAuthorizationConfiguration.CompositionType.OR;
        }

        @Override
        boolean grantsPermission(long permissions, @Nullable PropertyState property) {
            boolean isGranted = false;
            long coveredPermissions = 0L;
            for (int i = 0; i < this.length(); ++i) {
                TreePermission tp = this.treePermission(i);
                long supported = this.provider(i).supportedPermissions(tp, property, permissions);
                if (!Util.doEvaluate(supported)) continue;
                Iterator iterator = Permissions.aggregates((long)supported).iterator();
                while (iterator.hasNext()) {
                    long p = (Long)iterator.next();
                    boolean aGrant = property == null ? tp.isGranted(p) : tp.isGranted(p, property);
                    if (!aGrant) continue;
                    coveredPermissions |= p;
                    isGranted = true;
                }
            }
            return isGranted && coveredPermissions == permissions;
        }

        @Override
        boolean grantsRead(@Nullable PropertyState property) {
            if (property != null && this.canReadProperties()) {
                return true;
            }
            boolean readable = false;
            for (int i = 0; i < this.length(); ++i) {
                TreePermission tp = this.treePermission(i);
                long supported = this.provider(i).supportedPermissions(tp, property, property == null ? 1L : 2L);
                if (!Util.doEvaluate(supported)) continue;
                boolean bl = readable = property == null ? tp.canRead() : tp.canRead(property);
                if (!readable) continue;
                return true;
            }
            return readable;
        }

        @Override
        boolean grantsReadProperties() {
            boolean readable = false;
            for (int i = 0; i < this.length(); ++i) {
                TreePermission tp = this.treePermission(i);
                long supported = this.provider(i).supportedPermissions(tp, null, 2L);
                if (Util.doEvaluate(supported) && (readable = tp.canReadProperties())) break;
            }
            return readable;
        }
    }
}

