/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.cursor;

import java.util.HashSet;
import java.util.Iterator;
import org.apache.jackrabbit.guava.common.base.Predicate;
import org.apache.jackrabbit.guava.common.collect.Iterators;
import org.apache.jackrabbit.guava.common.collect.UnmodifiableIterator;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.index.cursor.AbstractCursor;
import org.apache.jackrabbit.oak.query.FilterIterators;
import org.apache.jackrabbit.oak.query.index.IndexRowImpl;
import org.apache.jackrabbit.oak.spi.query.IndexRow;
import org.apache.jackrabbit.oak.spi.query.QueryLimits;
import org.jetbrains.annotations.Nullable;

public class PathCursor
extends AbstractCursor {
    private final Iterator<String> iterator;

    public PathCursor(Iterator<String> paths, boolean distinct, final QueryLimits settings) {
        UnmodifiableIterator it = paths;
        if (distinct) {
            it = Iterators.filter(it, (Predicate)new Predicate<String>(){
                private final HashSet<String> known = new HashSet();

                public boolean apply(@Nullable String input) {
                    FilterIterators.checkMemoryLimit(this.known.size(), settings);
                    return this.known.add(input);
                }
            });
        }
        this.iterator = it;
    }

    public IndexRow next() {
        String path = this.iterator.next();
        return new IndexRowImpl((String)(PathUtils.isAbsolute((String)path) ? path : "/" + path));
    }

    public boolean hasNext() {
        return this.iterator.hasNext();
    }
}

