/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.util;

import java.util.List;
import java.util.Map;
import org.apache.jackrabbit.oak.cache.CacheStats;
import org.apache.jackrabbit.oak.plugins.document.ClusterNodeInfo;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.Document;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentStoreException;
import org.apache.jackrabbit.oak.plugins.document.Throttler;
import org.apache.jackrabbit.oak.plugins.document.UpdateOp;
import org.apache.jackrabbit.oak.plugins.document.cache.CacheInvalidationStats;
import org.jetbrains.annotations.NotNull;

public final class LeaseCheckDocumentStoreWrapper
implements DocumentStore {
    private final DocumentStore delegate;
    private final ClusterNodeInfo clusterNodeInfo;

    public LeaseCheckDocumentStoreWrapper(DocumentStore delegate, ClusterNodeInfo clusterNodeInfo) {
        if (delegate == null) {
            throw new IllegalArgumentException("delegate must not be null");
        }
        this.delegate = delegate;
        this.clusterNodeInfo = clusterNodeInfo;
    }

    private final void performLeaseCheck() {
        if (this.clusterNodeInfo != null) {
            this.clusterNodeInfo.performLeaseCheck();
        }
    }

    @Override
    public final <T extends Document> T find(Collection<T> collection, String key) {
        this.performLeaseCheck();
        return this.delegate.find(collection, key);
    }

    @Override
    public final <T extends Document> T find(Collection<T> collection, String key, int maxCacheAge) {
        this.performLeaseCheck();
        return this.delegate.find(collection, key, maxCacheAge);
    }

    @Override
    public final <T extends Document> List<T> query(Collection<T> collection, String fromKey, String toKey, int limit) {
        this.performLeaseCheck();
        return this.delegate.query(collection, fromKey, toKey, limit);
    }

    @Override
    public final <T extends Document> List<T> query(Collection<T> collection, String fromKey, String toKey, String indexedProperty, long startValue, int limit) {
        this.performLeaseCheck();
        return this.delegate.query(collection, fromKey, toKey, indexedProperty, startValue, limit);
    }

    @Override
    public <T extends Document> List<T> query(Collection<T> collection, String fromKey, String toKey, String indexedProperty, long startValue, int limit, List<String> projection) {
        this.performLeaseCheck();
        return this.delegate.query(collection, fromKey, toKey, indexedProperty, startValue, limit, projection);
    }

    @Override
    public final <T extends Document> void remove(Collection<T> collection, String key) {
        this.performLeaseCheck();
        this.delegate.remove(collection, key);
    }

    @Override
    public final <T extends Document> void remove(Collection<T> collection, List<String> keys) {
        this.performLeaseCheck();
        this.delegate.remove(collection, keys);
    }

    @Override
    public final <T extends Document> int remove(Collection<T> collection, Map<String, Long> toRemove) {
        this.performLeaseCheck();
        return this.delegate.remove(collection, toRemove);
    }

    @Override
    public <T extends Document> int remove(Collection<T> collection, String indexedProperty, long startValue, long endValue) throws DocumentStoreException {
        this.performLeaseCheck();
        return this.delegate.remove(collection, indexedProperty, startValue, endValue);
    }

    @Override
    public final <T extends Document> boolean create(Collection<T> collection, List<UpdateOp> updateOps) {
        this.performLeaseCheck();
        return this.delegate.create(collection, updateOps);
    }

    @Override
    public final <T extends Document> T createOrUpdate(Collection<T> collection, UpdateOp update) {
        this.performLeaseCheck();
        return this.delegate.createOrUpdate(collection, update);
    }

    @Override
    public <T extends Document> List<T> createOrUpdate(Collection<T> collection, List<UpdateOp> updateOps) {
        this.performLeaseCheck();
        return this.delegate.createOrUpdate(collection, updateOps);
    }

    @Override
    public final <T extends Document> T findAndUpdate(Collection<T> collection, UpdateOp update) {
        this.performLeaseCheck();
        return this.delegate.findAndUpdate(collection, update);
    }

    @Override
    public final CacheInvalidationStats invalidateCache() {
        this.performLeaseCheck();
        return this.delegate.invalidateCache();
    }

    @Override
    public final CacheInvalidationStats invalidateCache(Iterable<String> keys) {
        this.performLeaseCheck();
        return this.delegate.invalidateCache(keys);
    }

    @Override
    public final <T extends Document> void invalidateCache(Collection<T> collection, String key) {
        this.performLeaseCheck();
        this.delegate.invalidateCache(collection, key);
    }

    @Override
    public final void dispose() {
        this.delegate.dispose();
    }

    @Override
    public final <T extends Document> T getIfCached(Collection<T> collection, String key) {
        this.performLeaseCheck();
        return this.delegate.getIfCached(collection, key);
    }

    @Override
    public final void setReadWriteMode(String readWriteMode) {
        this.performLeaseCheck();
        this.delegate.setReadWriteMode(readWriteMode);
    }

    @Override
    public final Iterable<CacheStats> getCacheStats() {
        this.performLeaseCheck();
        return this.delegate.getCacheStats();
    }

    @Override
    public final Map<String, String> getMetadata() {
        this.performLeaseCheck();
        return this.delegate.getMetadata();
    }

    @Override
    @NotNull
    public Map<String, String> getStats() {
        this.performLeaseCheck();
        return this.delegate.getStats();
    }

    @Override
    public long determineServerTimeDifferenceMillis() {
        this.performLeaseCheck();
        return this.delegate.determineServerTimeDifferenceMillis();
    }

    @Override
    public <T extends Document> void prefetch(Collection<T> collection, Iterable<String> keys) {
        this.performLeaseCheck();
        this.delegate.prefetch(collection, keys);
    }

    @Override
    public int getNodeNameLimit() {
        return this.delegate.getNodeNameLimit();
    }

    @Override
    public Throttler throttler() {
        return this.delegate.throttler();
    }
}

