/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import java.util.stream.StreamSupport;
import org.apache.jackrabbit.guava.common.base.Predicate;
import org.apache.jackrabbit.guava.common.collect.Iterables;
import org.apache.jackrabbit.oak.plugins.document.ClusterNodeInfoDocument;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.Path;
import org.apache.jackrabbit.oak.plugins.document.RecoveryLock;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;
import org.apache.jackrabbit.oak.stats.Clock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MissingLastRevSeeker {
    private final DocumentStore store;
    protected final Clock clock;

    public MissingLastRevSeeker(DocumentStore store, Clock clock) {
        this.store = store;
        this.clock = clock;
    }

    @NotNull
    public Iterable<ClusterNodeInfoDocument> getAllClusters() {
        return ClusterNodeInfoDocument.all(this.store);
    }

    @Nullable
    public ClusterNodeInfoDocument getClusterNodeInfo(int clusterId) {
        return this.store.find(Collection.CLUSTER_NODES, String.valueOf(clusterId));
    }

    @NotNull
    public Iterable<NodeDocument> getCandidates(final long startTime) {
        Iterable<NodeDocument> nodes = Utils.getSelectedDocuments(this.store, "_modified", NodeDocument.getModifiedInSecs(startTime));
        return Iterables.filter(nodes, (Predicate)new Predicate<NodeDocument>(){

            public boolean apply(NodeDocument input) {
                Long modified = (Long)input.get("_modified");
                Long sdType = (Long)input.get("_sdType");
                return modified != null && modified >= NodeDocument.getModifiedInSecs(startTime) && sdType == null;
            }
        });
    }

    public boolean acquireRecoveryLock(int clusterId, int recoveredBy) {
        return new RecoveryLock(this.store, this.clock, clusterId).acquireRecoveryLock(recoveredBy);
    }

    public void releaseRecoveryLock(int clusterId, boolean success) {
        new RecoveryLock(this.store, this.clock, clusterId).releaseRecoveryLock(success);
    }

    public NodeDocument getRoot() {
        return this.store.find(Collection.NODES, Utils.getIdFromPath(Path.ROOT));
    }

    public boolean isRecoveryNeeded() {
        long now = this.clock.getTime();
        return StreamSupport.stream(this.getAllClusters().spliterator(), false).anyMatch(info -> info != null && info.isRecoveryNeeded(now));
    }

    public boolean isRecoveryNeeded(@NotNull ClusterNodeInfoDocument nodeInfo) {
        return nodeInfo.isRecoveryNeeded(this.clock.getTime());
    }
}

