/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file.tar.index;

import java.io.IOException;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.oak.segment.file.tar.index.Index;
import org.apache.jackrabbit.oak.segment.file.tar.index.IndexLoaderV1;
import org.apache.jackrabbit.oak.segment.file.tar.index.IndexLoaderV2;
import org.apache.jackrabbit.oak.segment.file.tar.index.InvalidIndexException;
import org.apache.jackrabbit.oak.segment.util.ReaderAtEnd;

public class IndexLoader {
    private final IndexLoaderV1 v1;
    private final IndexLoaderV2 v2;

    public static IndexLoader newIndexLoader(int blockSize) {
        Preconditions.checkArgument((blockSize > 0 ? 1 : 0) != 0, (Object)"Invalid block size");
        return new IndexLoader(blockSize);
    }

    private IndexLoader(int blockSize) {
        this.v1 = new IndexLoaderV1(blockSize);
        this.v2 = new IndexLoaderV2(blockSize);
    }

    private static int readMagic(ReaderAtEnd reader) throws IOException {
        return reader.readAtEnd(4, 4).getInt();
    }

    public Index loadIndex(ReaderAtEnd reader) throws IOException, InvalidIndexException {
        switch (IndexLoader.readMagic(reader)) {
            case 170937098: {
                return this.v1.loadIndex(reader);
            }
            case 171002634: {
                return this.v2.loadIndex(reader);
            }
        }
        throw new InvalidIndexException("Unrecognized magic number");
    }
}

