/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.property.strategy;

import java.util.Set;
import org.apache.jackrabbit.guava.common.base.Predicate;
import org.apache.jackrabbit.guava.common.base.Supplier;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.plugins.index.property.strategy.IndexStoreStrategy;
import org.apache.jackrabbit.oak.spi.query.Filter;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class FilteringIndexStoreStrategy
implements IndexStoreStrategy {
    private final IndexStoreStrategy strategy;
    private final Predicate<String> filter;
    private final boolean readOnly;

    public FilteringIndexStoreStrategy(IndexStoreStrategy strategy, Predicate<String> filter) {
        this(strategy, filter, false);
    }

    public FilteringIndexStoreStrategy(IndexStoreStrategy strategy, Predicate<String> filter, boolean readOnly) {
        this.strategy = strategy;
        this.filter = filter;
        this.readOnly = readOnly;
    }

    @Override
    public void update(Supplier<NodeBuilder> index, String path, String indexName, NodeBuilder indexMeta, Set<String> beforeKeys, Set<String> afterKeys) throws CommitFailedException {
        if (this.filter.apply((Object)path)) {
            if (this.readOnly) {
                throw new CommitFailedException("Unsupported", 0, "Unsupported commit to a read-only store!", new Throwable("Commit path: " + path));
            }
            this.strategy.update(index, path, indexName, indexMeta, beforeKeys, afterKeys);
        }
    }

    @Override
    public boolean exists(Supplier<NodeBuilder> index, String key) {
        return this.strategy.exists(index, key);
    }

    @Override
    public Iterable<String> query(Filter filter, String indexName, NodeState indexMeta, Iterable<String> values) {
        return this.strategy.query(filter, indexName, indexMeta, values);
    }

    @Override
    public long count(NodeState root, NodeState indexMeta, Set<String> values, int max) {
        return this.strategy.count(root, indexMeta, values, max);
    }

    @Override
    public long count(Filter filter, NodeState root, NodeState indexMeta, Set<String> values, int max) {
        return this.strategy.count(filter, root, indexMeta, values, max);
    }

    @Override
    public String getIndexNodeName() {
        return this.strategy.getIndexNodeName();
    }
}

