/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.mydb.service.impl;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.silverpeas.components.mydb.model.DataSourceDefinition;
import org.silverpeas.components.mydb.model.MyDBConnectionInfo;
import org.silverpeas.components.mydb.model.MyDBConnectionInfoRepository;
import org.silverpeas.components.mydb.service.MyDBConnectionInfoService;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.persistence.datasource.model.IdentifiableEntity;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.util.StringUtil;

@Service
@Transactional
public class SimpleMyDBConnectionInfoService
implements MyDBConnectionInfoService {
    private static final SettingBundle dataSources = ResourceLocator.getSettingBundle((String)"org.silverpeas.mydb.settings.dataSources");
    @Inject
    private MyDBConnectionInfoRepository repository;

    @Override
    public List<MyDBConnectionInfo> getConnectionInfoList(String instanceId) {
        return this.repository.findByInstanceId(instanceId);
    }

    @Override
    public void removeConnectionInfoOfComponentInstance(String componentInstanceId) {
        this.repository.deleteByInstanceId(componentInstanceId);
    }

    @Override
    public void saveConnectionInfo(MyDBConnectionInfo connectionInfo) {
        this.repository.save((IdentifiableEntity)connectionInfo);
    }

    @Override
    public List<DataSourceDefinition> getAllDataSourceDefinitions() {
        int count = dataSources.getInteger("dataSource.count", 0);
        ArrayList<DataSourceDefinition> dataSourceDefinitions = new ArrayList<DataSourceDefinition>(count);
        for (int i = 0; i < count; ++i) {
            String jndiName = dataSources.getString("dataSource." + i + ".name");
            String description = dataSources.getString("dataSource." + i + ".description");
            if (StringUtil.isNotDefined((String)description)) {
                description = "";
            }
            dataSourceDefinitions.add(new DataSourceDefinition(jndiName, description));
        }
        return dataSourceDefinitions;
    }
}

