/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.standby.server;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import org.apache.jackrabbit.oak.segment.standby.codec.GetSegmentRequest;
import org.apache.jackrabbit.oak.segment.standby.codec.GetSegmentResponse;
import org.apache.jackrabbit.oak.segment.standby.server.StandbySegmentReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GetSegmentRequestHandler
extends SimpleChannelInboundHandler<GetSegmentRequest> {
    private static final Logger log = LoggerFactory.getLogger(GetSegmentRequestHandler.class);
    private final StandbySegmentReader reader;

    GetSegmentRequestHandler(StandbySegmentReader reader) {
        this.reader = reader;
    }

    protected void channelRead0(ChannelHandlerContext ctx, GetSegmentRequest msg) throws Exception {
        log.debug("Reading segment {} for client {}", (Object)msg.getSegmentId(), (Object)msg.getClientId());
        byte[] data = this.reader.readSegment(msg.getSegmentId());
        if (data == null) {
            log.debug("Segment {} not found, discarding request from client {}", (Object)msg.getSegmentId(), (Object)msg.getClientId());
            return;
        }
        ctx.writeAndFlush((Object)new GetSegmentResponse(msg.getClientId(), msg.getSegmentId(), data));
    }
}

