/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.delegate;

import javax.jcr.InvalidItemStateException;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.jcr.delegate.NodeDelegate;
import org.apache.jackrabbit.oak.jcr.delegate.SessionDelegate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ItemDelegate {
    protected final SessionDelegate sessionDelegate;
    private long updateCount;

    ItemDelegate(SessionDelegate sessionDelegate) {
        this.sessionDelegate = (SessionDelegate)Preconditions.checkNotNull((Object)sessionDelegate);
        this.updateCount = sessionDelegate.getUpdateCount();
    }

    protected boolean checkUpdate() {
        long sessionCount = this.sessionDelegate.getUpdateCount();
        if (this.updateCount != sessionCount) {
            this.updateCount = sessionCount;
            this.update();
            return true;
        }
        return false;
    }

    protected void update() {
    }

    public synchronized void checkAlive() throws RepositoryException {
        this.sessionDelegate.checkAlive();
        if (this.checkUpdate() && !this.exists()) {
            throw new InvalidItemStateException("This item [" + this.getPath() + "] does not exist anymore");
        }
    }

    @NotNull
    public abstract String getName();

    @NotNull
    public abstract String getPath();

    @Nullable
    public abstract NodeDelegate getParent();

    @Nullable
    public abstract Tree.Status getStatus();

    public abstract boolean isProtected() throws InvalidItemStateException;

    public abstract boolean exists();

    public abstract boolean remove() throws InvalidItemStateException;

    public void save() throws RepositoryException {
        this.sessionDelegate.save(this.getPath());
    }
}

