/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.commit;

import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateDiff;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorDiff
implements NodeStateDiff {
    private final Editor editor;
    private CommitFailedException exception;

    @Nullable
    public static CommitFailedException process(@Nullable Editor editor, @NotNull NodeState before, @NotNull NodeState after) {
        Preconditions.checkNotNull((Object)before);
        Preconditions.checkNotNull((Object)after);
        if (editor != null) {
            try {
                editor.enter(before, after);
                EditorDiff diff = new EditorDiff(editor);
                if (!after.compareAgainstBaseState(before, diff)) {
                    return diff.exception;
                }
                editor.leave(before, after);
            }
            catch (CommitFailedException e) {
                return e;
            }
        }
        return null;
    }

    private EditorDiff(Editor editor) {
        this.editor = editor;
    }

    @Override
    public boolean propertyAdded(PropertyState after) {
        try {
            this.editor.propertyAdded(after);
            return true;
        }
        catch (CommitFailedException e) {
            this.exception = e;
            return false;
        }
    }

    @Override
    public boolean propertyChanged(PropertyState before, PropertyState after) {
        try {
            this.editor.propertyChanged(before, after);
            return true;
        }
        catch (CommitFailedException e) {
            this.exception = e;
            return false;
        }
    }

    @Override
    public boolean propertyDeleted(PropertyState before) {
        try {
            this.editor.propertyDeleted(before);
            return true;
        }
        catch (CommitFailedException e) {
            this.exception = e;
            return false;
        }
    }

    @Override
    public boolean childNodeAdded(String name, NodeState after) {
        try {
            NodeState before = EmptyNodeState.MISSING_NODE;
            Editor childEditor = this.editor.childNodeAdded(name, after);
            if (childEditor != null) {
                childEditor.enter(before, after);
                EditorDiff diff = new EditorDiff(childEditor);
                if (!after.compareAgainstBaseState(before, diff)) {
                    this.exception = diff.exception;
                    return false;
                }
                childEditor.leave(before, after);
            }
            return true;
        }
        catch (CommitFailedException e) {
            this.exception = e;
            return false;
        }
    }

    @Override
    public boolean childNodeChanged(String name, NodeState before, NodeState after) {
        try {
            Editor childEditor = this.editor.childNodeChanged(name, before, after);
            if (childEditor != null) {
                childEditor.enter(before, after);
                EditorDiff diff = new EditorDiff(childEditor);
                if (!after.compareAgainstBaseState(before, diff)) {
                    this.exception = diff.exception;
                    return false;
                }
                childEditor.leave(before, after);
            }
            return true;
        }
        catch (CommitFailedException e) {
            this.exception = e;
            return false;
        }
    }

    @Override
    public boolean childNodeDeleted(String name, NodeState before) {
        try {
            NodeState after = EmptyNodeState.MISSING_NODE;
            Editor childEditor = this.editor.childNodeDeleted(name, before);
            if (childEditor != null) {
                childEditor.enter(before, after);
                EditorDiff diff = new EditorDiff(childEditor);
                if (!after.compareAgainstBaseState(before, diff)) {
                    this.exception = diff.exception;
                    return false;
                }
                childEditor.leave(before, after);
            }
            return true;
        }
        catch (CommitFailedException e) {
            this.exception = e;
            return false;
        }
    }
}

