/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.suggestionbox.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.silverpeas.components.suggestionbox.model.Suggestion;
import org.silverpeas.components.suggestionbox.model.SuggestionBoxService;
import org.silverpeas.components.suggestionbox.model.SuggestionCollection;
import org.silverpeas.core.admin.component.model.ComponentInstLight;
import org.silverpeas.core.admin.service.OrganizationControllerProvider;
import org.silverpeas.core.admin.user.model.SilverpeasRole;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.persistence.datasource.model.identifier.UuidIdentifier;
import org.silverpeas.core.persistence.datasource.model.jpa.SilverpeasJpaEntity;

@Entity
@NamedQuery(name="suggestionBoxFromComponentInstance", query="from SuggestionBox s where s.componentInstanceId = :componentInstanceId")
@Table(name="sc_suggestion_box")
public class SuggestionBox
extends SilverpeasJpaEntity<SuggestionBox, UuidIdentifier> {
    private static final long serialVersionUID = -3216638631298619076L;
    @Column(name="instanceId", nullable=false)
    private String componentInstanceId;
    @OneToMany(mappedBy="suggestionBox", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<Suggestion> suggestions;
    @Transient
    private ComponentInstLight componentInst;

    public static SuggestionBox getByComponentInstanceId(String suggestionBoxId) {
        SuggestionBoxService suggestionBoxService = SuggestionBox.getSuggestionBoxService();
        return suggestionBoxService.getByComponentInstanceId(suggestionBoxId);
    }

    public SuggestionBox(String componentInstanceId) {
        this.componentInstanceId = componentInstanceId;
        this.suggestions = new ArrayList<Suggestion>();
    }

    public String getComponentInstanceId() {
        return this.componentInstanceId;
    }

    public String getTitle(String language) {
        return this.getComponentInst().getName(language);
    }

    public String getDescription(String language) {
        return this.getComponentInst().getDescription(language);
    }

    public SuggestionCollection getSuggestions() {
        return new SuggestionCollection(this);
    }

    protected SuggestionBox() {
    }

    private ComponentInstLight getComponentInst() {
        if (this.componentInst == null) {
            this.componentInst = OrganizationControllerProvider.getOrganisationController().getComponentInstLight(this.getComponentInstanceId());
        }
        return this.componentInst;
    }

    protected List<Suggestion> persistedSuggestions() {
        return this.suggestions;
    }

    public SilverpeasRole getHighestUserRole(User user) {
        String[] profiles = OrganizationControllerProvider.getOrganisationController().getUserProfiles(user.getId(), this.getComponentInstanceId());
        Set userRoles = SilverpeasRole.fromStrings((String[])profiles);
        SilverpeasRole role = SilverpeasRole.getHighestFrom((Collection)userRoles);
        return role != null ? role : SilverpeasRole.READER;
    }

    private static SuggestionBoxService getSuggestionBoxService() {
        return SuggestionBoxService.get();
    }
}

