/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.resourcesmanager;

import javax.inject.Inject;
import javax.inject.Named;
import javax.transaction.Transactional;
import org.silverpeas.components.resourcesmanager.repository.CategoryRepository;
import org.silverpeas.components.resourcesmanager.repository.ReservationRepository;
import org.silverpeas.components.resourcesmanager.repository.ReservedResourceRepository;
import org.silverpeas.components.resourcesmanager.repository.ResourceRepository;
import org.silverpeas.components.resourcesmanager.repository.ResourceValidatorRepository;
import org.silverpeas.core.admin.component.ComponentInstancePreDestruction;

@Named
public class ResourcesManagerInstancePreDestruction
implements ComponentInstancePreDestruction {
    @Inject
    private CategoryRepository categoryRepository;
    @Inject
    private ReservationRepository reservationRepository;
    @Inject
    private ReservedResourceRepository reservedResourceRepository;
    @Inject
    private ResourceRepository resourceRepository;
    @Inject
    private ResourceValidatorRepository resourceValidatorRepository;

    @Transactional
    public void preDestroy(String componentInstanceId) {
        this.reservedResourceRepository.deleteByComponentInstanceId(componentInstanceId);
        this.reservationRepository.deleteByComponentInstanceId(componentInstanceId);
        this.resourceValidatorRepository.deleteByComponentInstanceId(componentInstanceId);
        this.resourceRepository.deleteByComponentInstanceId(componentInstanceId);
        this.categoryRepository.deleteByComponentInstanceId(componentInstanceId);
    }
}

