/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.gallery.media;

import com.drew.imaging.ImageMetadataReader;
import com.drew.imaging.ImageProcessingException;
import com.drew.metadata.Metadata;
import com.drew.metadata.exif.ExifIFD0Descriptor;
import com.drew.metadata.exif.ExifIFD0Directory;
import com.drew.metadata.iptc.IptcDirectory;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import org.silverpeas.components.gallery.media.AbstractMediaMetadataExtractor;
import org.silverpeas.components.gallery.media.ExifProperty;
import org.silverpeas.components.gallery.media.IptcProperty;
import org.silverpeas.components.gallery.media.MediaMetadataException;
import org.silverpeas.components.gallery.model.MetaData;
import org.silverpeas.core.i18n.I18NHelper;
import org.silverpeas.core.util.ArrayUtil;
import org.silverpeas.core.util.Charsets;
import org.silverpeas.core.util.EncodingUtil;

public class DrewMediaMetadataExtractor
extends AbstractMediaMetadataExtractor {
    public DrewMediaMetadataExtractor(String instanceId) {
        this.init(instanceId);
    }

    @Override
    public List<MetaData> extractImageExifMetaData(File image) throws MediaMetadataException, IOException {
        return this.extractImageExifMetaData(image, I18NHelper.DEFAULT_LANGUAGE);
    }

    @Override
    public List<MetaData> extractImageExifMetaData(File image, String lang) throws MediaMetadataException, IOException {
        try {
            ArrayList<MetaData> result = new ArrayList<MetaData>();
            Metadata metadata = ImageMetadataReader.readMetadata((File)image);
            ExifIFD0Directory exifDirectory = (ExifIFD0Directory)metadata.getFirstDirectoryOfType(ExifIFD0Directory.class);
            ExifIFD0Descriptor descriptor = new ExifIFD0Descriptor(exifDirectory);
            if (exifDirectory != null) {
                for (ExifProperty property : this.imageProperties) {
                    String value = this.fetchLabel(exifDirectory, descriptor, property);
                    if (value == null) continue;
                    this.addLabelToMediaMetadata(lang, result, value, property);
                }
            }
            return result;
        }
        catch (ImageProcessingException | IOException ex) {
            throw new MediaMetadataException(ex);
        }
    }

    private void addLabelToMediaMetadata(String lang, List<MetaData> result, String value, ExifProperty property) {
        MetaData metaData = new MetaData(value);
        metaData.setLabel(property.getLabel(lang));
        metaData.setProperty("" + property.getProperty());
        result.add(metaData);
    }

    private String fetchLabel(ExifIFD0Directory exifDirectory, ExifIFD0Descriptor descriptor, ExifProperty property) {
        String value;
        int currentMetadata = property.getProperty();
        switch (currentMetadata) {
            case 40093: {
                value = descriptor.getWindowsAuthorDescription();
                break;
            }
            case 40092: {
                value = descriptor.getWindowsCommentDescription();
                break;
            }
            case 40094: {
                value = descriptor.getWindowsKeywordsDescription();
                break;
            }
            case 40095: {
                value = descriptor.getWindowsSubjectDescription();
                break;
            }
            case 40091: {
                value = descriptor.getWindowsTitleDescription();
                break;
            }
            case 296: {
                value = this.getExifDirectoryValue(exifDirectory, currentMetadata);
                break;
            }
            default: {
                value = exifDirectory.getString(currentMetadata);
            }
        }
        return value;
    }

    private String getExifDirectoryValue(ExifIFD0Directory exifDirectory, int currentMetadata) {
        String value = exifDirectory.getString(currentMetadata);
        if ("2".equals(value)) {
            value = "DPI";
        } else if ("3".equals(value)) {
            value = "DPC";
        }
        return value;
    }

    @Override
    public List<MetaData> extractImageIptcMetaData(File image) throws MediaMetadataException, IOException {
        return this.extractImageIptcMetaData(image, I18NHelper.DEFAULT_LANGUAGE);
    }

    @Override
    public List<MetaData> extractImageIptcMetaData(File image, String lang) throws IOException, MediaMetadataException {
        try {
            int defaultSize = 1024;
            ArrayList<MetaData> result = new ArrayList<MetaData>();
            Metadata metadata = ImageMetadataReader.readMetadata((File)image);
            ByteArrayOutputStream forEncodingDetection = new ByteArrayOutputStream(1024);
            IptcDirectory iptcDirectory = (IptcDirectory)metadata.getFirstDirectoryOfType(IptcDirectory.class);
            String iptcCharset = this.getIptcCharset(iptcDirectory);
            block5: for (IptcProperty iptcProperty : this.imageIptcProperties) {
                switch (iptcProperty.getProperty()) {
                    case 537: 
                    case 542: 
                    case 567: {
                        this.addStringMetaData(result, iptcDirectory, iptcProperty, lang, forEncodingDetection);
                        continue block5;
                    }
                }
                this.addMetaData(result, iptcDirectory, iptcProperty, lang, forEncodingDetection);
            }
            String defaultEncoding = Charsets.UTF_8.name();
            if (iptcCharset != null) {
                defaultEncoding = iptcCharset;
            }
            String encoding = EncodingUtil.detectStringEncoding((byte[])forEncodingDetection.toByteArray(), (String)defaultEncoding);
            for (MetaData metaData : result) {
                metaData.convert(encoding);
            }
            return result;
        }
        catch (ImageProcessingException ex) {
            throw new MediaMetadataException(ex);
        }
    }

    private void addStringMetaData(List<MetaData> metadata, IptcDirectory iptcDirectory, IptcProperty iptcProperty, String lang, ByteArrayOutputStream forEncodingDetection) throws IOException {
        String value = this.getIptcStringValue(iptcDirectory, iptcProperty.getProperty());
        if (value != null) {
            MetaData meta = new MetaData(value.getBytes());
            meta.setLabel(iptcProperty.getLabel(lang));
            meta.setProperty(String.valueOf(iptcProperty.getProperty()));
            if (iptcProperty.isDate()) {
                meta.setDate(true);
                meta.setDateValue(iptcDirectory.getDate(iptcProperty.getProperty(), TimeZone.getDefault()));
            } else {
                forEncodingDetection.write(value.getBytes());
            }
            metadata.add(meta);
        }
    }

    private void addMetaData(List<MetaData> metadata, IptcDirectory iptcDirectory, IptcProperty iptcProperty, String lang, ByteArrayOutputStream forEncodingDetection) throws IOException {
        byte[] data = this.getIptcValue(iptcDirectory, iptcProperty.getProperty());
        if (data != null && !ArrayUtil.isEmpty((byte[])data)) {
            MetaData meta = new MetaData(data);
            meta.setLabel(iptcProperty.getLabel(lang));
            meta.setProperty(String.valueOf(iptcProperty.getProperty()));
            if (iptcProperty.isDate() && iptcDirectory != null) {
                meta.setDate(true);
                meta.setDateValue(iptcDirectory.getDate(iptcProperty.getProperty(), TimeZone.getDefault()));
            } else {
                forEncodingDetection.write(data);
            }
            metadata.add(meta);
        }
    }

    private byte[] getIptcValue(IptcDirectory iptcDirectory, int iptcTag) {
        if (iptcDirectory != null && iptcDirectory.containsTag(iptcTag)) {
            return iptcDirectory.getByteArray(iptcTag);
        }
        return new byte[0];
    }

    private String getIptcStringValue(IptcDirectory iptcDirectory, int iptcTag) {
        if (iptcDirectory != null && iptcDirectory.containsTag(iptcTag)) {
            return iptcDirectory.getString(iptcTag);
        }
        return null;
    }

    private String getIptcCharset(IptcDirectory iptcDirectory) {
        String escapeCode;
        byte[] data;
        if (iptcDirectory != null && iptcDirectory.containsTag(346) && (data = iptcDirectory.getByteArray(346)) != null && "\u001b%G".equals(escapeCode = new String(data, Charsets.UTF_8))) {
            return Charsets.UTF_8.name();
        }
        return null;
    }
}

