/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.security;

import java.security.GeneralSecurityException;
import java.util.HashMap;

public class EncryptionAlgorithms {
    static final HashMap<String, String> algorithmNames = new HashMap();

    public static String getAlgorithm(String oid) {
        String ret = algorithmNames.get(oid);
        if (ret == null) {
            return oid;
        }
        return ret;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean addAlgorithm(String oid, String name) throws GeneralSecurityException {
        boolean status = false;
        if (oid == null) throw new GeneralSecurityException("Can not register oid's with null or empty");
        if (oid.equals("")) throw new GeneralSecurityException("Can not register oid's with null or empty");
        if (!algorithmNames.containsKey(oid)) {
            algorithmNames.put(oid, name);
            return true;
        }
        if (!algorithmNames.get(oid).equals(name)) throw new GeneralSecurityException("already registered oid=" + oid + ", with name=" + algorithmNames.get(oid));
        return false;
    }

    static {
        algorithmNames.put("1.2.840.113549.1.1.1", "RSA");
        algorithmNames.put("1.2.840.10040.4.1", "DSA");
        algorithmNames.put("1.2.840.113549.1.1.2", "RSA");
        algorithmNames.put("1.2.840.113549.1.1.4", "RSA");
        algorithmNames.put("1.2.840.113549.1.1.5", "RSA");
        algorithmNames.put("1.2.840.113549.1.1.14", "RSA");
        algorithmNames.put("1.2.840.113549.1.1.11", "RSA");
        algorithmNames.put("1.2.840.113549.1.1.12", "RSA");
        algorithmNames.put("1.2.840.113549.1.1.13", "RSA");
        algorithmNames.put("1.2.840.10040.4.3", "DSA");
        algorithmNames.put("2.16.840.1.101.3.4.3.1", "DSA");
        algorithmNames.put("2.16.840.1.101.3.4.3.2", "DSA");
        algorithmNames.put("1.3.14.3.2.29", "RSA");
        algorithmNames.put("1.3.36.3.3.1.2", "RSA");
        algorithmNames.put("1.3.36.3.3.1.3", "RSA");
        algorithmNames.put("1.3.36.3.3.1.4", "RSA");
        algorithmNames.put("1.2.643.2.2.19", "ECGOST3410");
    }
}

