/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.delegatednews.model;

import java.io.Serializable;
import java.time.ZoneId;
import java.time.temporal.Temporal;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import javax.persistence.AttributeOverride;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import org.silverpeas.core.contribution.model.ContributionIdentifier;
import org.silverpeas.core.contribution.publication.model.PublicationDetail;
import org.silverpeas.core.contribution.publication.model.PublicationPK;
import org.silverpeas.core.contribution.publication.model.PublicationRuntimeException;
import org.silverpeas.core.contribution.publication.service.PublicationService;
import org.silverpeas.core.date.Period;
import org.silverpeas.core.date.TemporalConverter;
import org.silverpeas.core.persistence.datasource.model.identifier.ExternalIntegerIdentifier;
import org.silverpeas.core.persistence.datasource.model.jpa.BasicJpaEntity;

@Entity
@Table(name="sc_delegatednews_news")
@AttributeOverride(name="id", column=@Column(name="pubId", columnDefinition="int"))
@NamedQueries(value={@NamedQuery(name="delegatednews.findByStatus", query="SELECT dn FROM DelegatedNews dn WHERE dn.status = :status AND ((dn.beginDate is null AND dn.endDate is null) OR (dn.beginDate is null AND dn.endDate is not null AND CURRENT_TIMESTAMP <= dn.endDate) OR (dn.beginDate is not null AND dn.endDate is null AND CURRENT_TIMESTAMP >= dn.beginDate) OR (dn.beginDate is not null AND dn.endDate is not null AND CURRENT_TIMESTAMP >= dn.beginDate AND CURRENT_TIMESTAMP <= dn.endDate) )ORDER BY dn.newsOrder ASC"), @NamedQuery(name="delegatednews.findAllOrderedNews", query="SELECT dn FROM DelegatedNews dn ORDER BY dn.newsOrder ASC, dn.beginDate ASC, dn.id.id ASC")})
public class DelegatedNews
extends BasicJpaEntity<DelegatedNews, ExternalIntegerIdentifier>
implements Serializable {
    private static final long serialVersionUID = 9192830552642027995L;
    @Column(name="instanceId")
    private String instanceId;
    @Column(name="status")
    private String status;
    @Column(name="contributorId")
    private String contributorId;
    @Column(name="validatorId")
    private String validatorId;
    @Column(name="validationDate", columnDefinition="TIMESTAMP")
    private Date validationDate;
    @Column(name="beginDate", columnDefinition="TIMESTAMP")
    private Date beginDate;
    @Column(name="endDate", columnDefinition="TIMESTAMP")
    private Date endDate;
    @Column(name="newsOrder")
    private int newsOrder = 0;
    public static final String NEWS_TO_VALIDATE = "ToValidate";
    public static final String NEWS_VALID = "Valid";
    public static final String NEWS_REFUSED = "Refused";

    public DelegatedNews() {
    }

    public DelegatedNews(ContributionIdentifier contributionId, String contributorId, Date validationDate, Period visibilityPeriod) {
        this.setId(contributionId.getLocalId());
        this.instanceId = contributionId.getComponentInstanceId();
        this.status = NEWS_TO_VALIDATE;
        this.contributorId = contributorId;
        if (validationDate != null) {
            this.validationDate = new Date(validationDate.getTime());
        }
        this.setVisibilityPeriod(visibilityPeriod);
    }

    public String getPubId() {
        return this.getId();
    }

    public void setPubId(int pubId) {
        this.setId(Integer.toString(pubId));
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getContributorId() {
        return this.contributorId;
    }

    public void setContributorId(String contributorId) {
        this.contributorId = contributorId;
    }

    public String getValidatorId() {
        return this.validatorId;
    }

    public void setValidatorId(String validatorId) {
        this.validatorId = validatorId;
    }

    public Date getValidationDate() {
        return this.validationDate;
    }

    public void setValidationDate(Date validationDate) {
        this.validationDate = validationDate;
    }

    public Date getBeginDate() {
        return this.beginDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public final void setVisibilityPeriod(Period visibilityPeriod) {
        Optional<Period> specificPeriod = Optional.ofNullable(visibilityPeriod);
        this.beginDate = specificPeriod.filter(p -> !p.startsAtMinDate()).map(p -> TemporalConverter.asDate((Temporal)TemporalConverter.asOffsetDateTime((Temporal)p.getStartDate()).atZoneSameInstant(ZoneId.systemDefault()))).orElse(null);
        this.endDate = specificPeriod.filter(p -> !p.endsAtMaxDate()).map(p -> TemporalConverter.asDate((Temporal)TemporalConverter.asOffsetDateTime((Temporal)p.getEndDate()).atZoneSameInstant(ZoneId.systemDefault()))).orElse(null);
    }

    public int getNewsOrder() {
        return this.newsOrder;
    }

    public void setNewsOrder(int newsOrder) {
        this.newsOrder = newsOrder;
    }

    public boolean isValidated() {
        return NEWS_VALID.equals(this.getStatus());
    }

    public boolean isDenied() {
        return NEWS_REFUSED.equals(this.getStatus());
    }

    public boolean isWaitingForValidation() {
        return NEWS_TO_VALIDATE.equals(this.getStatus());
    }

    public PublicationDetail getPublicationDetail() {
        try {
            PublicationService publicationService = PublicationService.get();
            PublicationPK pubPk = new PublicationPK(this.getId(), this.instanceId);
            return publicationService.getDetail(pubPk);
        }
        catch (Exception e) {
            throw new PublicationRuntimeException((Throwable)e);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DelegatedNews other = (DelegatedNews)obj;
        if (!this.getPubId().equals(other.getPubId())) {
            return false;
        }
        if (!Objects.equals(this.instanceId, other.instanceId)) {
            return false;
        }
        if (!Objects.equals(this.status, other.status)) {
            return false;
        }
        if (!Objects.equals(this.contributorId, other.contributorId)) {
            return false;
        }
        if (!Objects.equals(this.validatorId, other.validatorId)) {
            return false;
        }
        if (!Objects.equals(this.validationDate, other.validationDate)) {
            return false;
        }
        if (!Objects.equals(this.beginDate, other.beginDate)) {
            return false;
        }
        if (!Objects.equals(this.endDate, other.endDate)) {
            return false;
        }
        return this.newsOrder == -1 ? other.newsOrder == -1 : this.newsOrder == other.newsOrder;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Integer.parseInt(this.getPubId());
        result = 31 * result + (this.instanceId == null ? 0 : this.instanceId.hashCode());
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        result = 31 * result + (this.contributorId == null ? 0 : this.contributorId.hashCode());
        result = 31 * result + (this.validatorId == null ? 0 : this.validatorId.hashCode());
        result = 31 * result + (this.validationDate == null ? 0 : this.validationDate.hashCode());
        result = 31 * result + (this.beginDate == null ? 0 : this.beginDate.hashCode());
        result = 31 * result + (this.endDate == null ? 0 : this.endDate.hashCode());
        result = 31 * result + this.newsOrder;
        return result;
    }

    public String toString() {
        return "DelegatedNews {pubId=" + this.getPubId() + ", instanceId=" + this.instanceId + ", status=" + this.status + ", contributorId=" + this.contributorId + ", validatorId=" + this.validatorId + ", validationDate=" + this.validationDate + ", beginDate=" + this.beginDate + ", endDate=" + this.endDate + ", newsOrder=" + this.newsOrder + "}";
    }
}

