/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.rdb;

import java.util.Arrays;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBBlobStoreDB;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBDocumentStore;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBDocumentStoreDB;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBOptions;

public class RDBHelper {
    private static String[] DATABASES = new String[]{"Apache Derby", "DB2", "H2", "Microsoft SQL Server", "MySQL", "Oracle", "PostgreSQL", "default"};

    public static void main(String[] args) {
        RDBOptions defaultOpts = new RDBOptions();
        int initial = defaultOpts.getInitialSchema();
        int upgradeTo = defaultOpts.getUpgradeToSchema();
        System.out.println("Table Creation Statements for RDBBlobStore and RDBDocumentStore");
        System.out.println("RDBDocumentStore initial version: " + initial + ", with modifications up to version: " + upgradeTo);
        System.out.println("(use system properties org.apache.jackrabbit.oak.plugins.document.rdb.RDBOptions.INITIALSCHEMA and org.apache.jackrabbit.oak.plugins.document.rdb.RDBOptions.UPGRADETOSCHEMA to specify initial DB schema, and schema to upgrade to)");
        System.out.println();
        for (String database : DATABASES) {
            RDBHelper.internalDump(database, initial, upgradeTo);
        }
    }

    public static String getSupportedDatabases() {
        return Arrays.asList(DATABASES).toString();
    }

    public static void dump(String database, Integer initial, Integer upgrade) {
        RDBOptions defaultOpts = new RDBOptions();
        if (database == null) {
            RDBHelper.internalDump(initial == null ? defaultOpts.getInitialSchema() : initial.intValue(), upgrade == null ? defaultOpts.getUpgradeToSchema() : upgrade.intValue());
        } else {
            RDBHelper.internalDump(database, initial == null ? defaultOpts.getInitialSchema() : initial.intValue(), upgrade == null ? defaultOpts.getUpgradeToSchema() : upgrade.intValue());
        }
    }

    private static void internalDump(int initial, int upgradeTo) {
        for (String database : DATABASES) {
            RDBHelper.internalDump(database, initial, upgradeTo);
            System.out.println();
        }
    }

    private static void internalDump(String database, int initial, int upgradeTo) {
        System.out.println("-- " + database);
        RDBDocumentStoreDB ddb = RDBDocumentStoreDB.getValue(database);
        RDBBlobStoreDB bdb = RDBBlobStoreDB.getValue(database);
        for (String table : RDBDocumentStore.getTableNames()) {
            System.out.println();
            System.out.println("  -- creating table " + table + " for schema version " + initial);
            System.out.println("  " + ddb.getTableCreationStatement(table, initial));
            for (String s : ddb.getIndexCreationStatements(table, initial)) {
                System.out.println("  " + s);
            }
            for (int level = initial + 1; level <= upgradeTo; ++level) {
                System.out.println("  -- upgrading table " + table + " to schema version " + level);
                for (String statement : ddb.getTableUpgradeStatements(table, level)) {
                    System.out.println("  " + statement);
                }
            }
        }
        System.out.println();
        System.out.println("   -- creating blob store tables");
        System.out.println("  " + bdb.getMetaTableCreationStatement("DATASTORE_META"));
        System.out.println("  " + bdb.getDataTableCreationStatement("DATASTORE_DATA"));
        System.out.println();
        System.out.println();
    }
}

