/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.persistentCache;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeState;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.NamePathRev;
import org.apache.jackrabbit.oak.plugins.document.Path;
import org.apache.jackrabbit.oak.plugins.document.PathRev;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.RevisionVector;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.WriteBuffer;
import org.h2.mvstore.type.DataType;
import org.h2.mvstore.type.StringDataType;

class DataTypeUtil {
    DataTypeUtil() {
    }

    static void booleanToBuffer(boolean b, WriteBuffer buffer) {
        buffer.put((byte)(b ? 1 : 0));
    }

    static boolean booleanFromBuffer(ByteBuffer buffer) {
        return buffer.get() != 0;
    }

    static void revisionVectorToBuffer(RevisionVector rv, WriteBuffer buffer) {
        buffer.putVarInt(rv.getDimensions());
        for (Revision r : rv) {
            buffer.putLong(r.getTimestamp());
            buffer.putVarInt(r.getCounter());
            buffer.putVarInt(r.getClusterId());
            DataTypeUtil.booleanToBuffer(r.isBranch(), buffer);
        }
    }

    static RevisionVector revisionVectorFromBuffer(ByteBuffer buffer) {
        int dim = DataUtils.readVarInt((ByteBuffer)buffer);
        ArrayList<Revision> revisions = new ArrayList<Revision>();
        for (int i = 0; i < dim; ++i) {
            revisions.add(new Revision(buffer.getLong(), DataUtils.readVarInt((ByteBuffer)buffer), DataUtils.readVarInt((ByteBuffer)buffer), DataTypeUtil.booleanFromBuffer(buffer)));
        }
        return new RevisionVector(revisions);
    }

    static void pathToBuffer(Path p, WriteBuffer buffer) {
        int len = p.getDepth() + (p.isAbsolute() ? 1 : 0);
        buffer.putVarInt(len);
        while (p != null) {
            StringDataType.INSTANCE.write(buffer, p.getName());
            p = p.getParent();
        }
    }

    static Path pathFromBuffer(ByteBuffer buffer) {
        int numElements = DataUtils.readVarInt((ByteBuffer)buffer);
        ArrayList<String> elements = new ArrayList<String>(numElements);
        for (int i = 0; i < numElements; ++i) {
            elements.add(StringDataType.INSTANCE.read(buffer));
        }
        String firstElement = (String)elements.get(elements.size() - 1);
        Path p = firstElement.isEmpty() ? Path.ROOT : new Path(firstElement);
        for (int i = elements.size() - 2; i >= 0; --i) {
            p = new Path(p, (String)elements.get(i));
        }
        return p;
    }

    static void pathRevToBuffer(PathRev pr, WriteBuffer buffer) {
        DataTypeUtil.pathToBuffer(pr.getPath(), buffer);
        DataTypeUtil.revisionVectorToBuffer(pr.getRevision(), buffer);
    }

    static PathRev pathRevFromBuffer(ByteBuffer buffer) {
        return new PathRev(DataTypeUtil.pathFromBuffer(buffer), DataTypeUtil.revisionVectorFromBuffer(buffer));
    }

    static void namePathRevToBuffer(NamePathRev pnr, WriteBuffer buffer) {
        StringDataType.INSTANCE.write(buffer, pnr.getName());
        DataTypeUtil.pathToBuffer(pnr.getPath(), buffer);
        DataTypeUtil.revisionVectorToBuffer(pnr.getRevision(), buffer);
    }

    static NamePathRev namePathRevFromBuffer(ByteBuffer buffer) {
        return new NamePathRev(StringDataType.INSTANCE.read(buffer), DataTypeUtil.pathFromBuffer(buffer), DataTypeUtil.revisionVectorFromBuffer(buffer));
    }

    static void stateToBuffer(DocumentNodeState state, WriteBuffer buffer) {
        DataTypeUtil.pathToBuffer(state.getPath(), buffer);
        DataTypeUtil.revisionVectorToBuffer(state.getRootRevision(), buffer);
        RevisionVector lastRevision = state.getLastRevision();
        if (lastRevision == null) {
            lastRevision = RevisionVector.fromString("");
        }
        DataTypeUtil.revisionVectorToBuffer(lastRevision, buffer);
        buffer.putVarInt(state.getMemory());
        DataTypeUtil.booleanToBuffer(state.hasNoChildren(), buffer);
        Map<String, String> props = state.getAllBundledProperties();
        buffer.putVarInt(props.size());
        for (Map.Entry<String, String> e : props.entrySet()) {
            StringDataType.INSTANCE.write(buffer, e.getKey());
            StringDataType.INSTANCE.write(buffer, e.getValue());
        }
    }

    static DocumentNodeState stateFromBuffer(DocumentNodeStore store, ByteBuffer buffer) {
        Path p = DataTypeUtil.pathFromBuffer(buffer);
        RevisionVector rootRevision = DataTypeUtil.revisionVectorFromBuffer(buffer);
        RevisionVector lastRevision = DataTypeUtil.revisionVectorFromBuffer(buffer);
        if (lastRevision.getDimensions() == 0) {
            lastRevision = null;
        }
        int mem = DataUtils.readVarInt((ByteBuffer)buffer);
        boolean noChildren = DataTypeUtil.booleanFromBuffer(buffer);
        int numProps = DataUtils.readVarInt((ByteBuffer)buffer);
        HashMap<String, PropertyState> props = new HashMap<String, PropertyState>(numProps);
        for (int i = 0; i < numProps; ++i) {
            String name = StringDataType.INSTANCE.read(buffer);
            String value = StringDataType.INSTANCE.read(buffer);
            props.put(name, store.createPropertyState(name, value));
        }
        return new DocumentNodeState(store, p, rootRevision, props, !noChildren, mem, lastRevision, false);
    }

    static Object[] cast(Object storage) {
        return (Object[])storage;
    }

    static int binarySearch(DataType<Object> dataType, Object key, Object storageObj, int size, int initialGuess) {
        Object[] storage = DataTypeUtil.cast(storageObj);
        int low = 0;
        int high = size - 1;
        int x = initialGuess - 1;
        if (x < 0 || x > high) {
            x = high >>> 1;
        }
        while (low <= high) {
            int compare = dataType.compare(key, storage[x]);
            if (compare > 0) {
                low = x + 1;
            } else if (compare < 0) {
                high = x - 1;
            } else {
                return x;
            }
            x = low + high >>> 1;
        }
        return ~low;
    }
}

