/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.accesscontrol;

import java.util.Comparator;
import javax.jcr.security.AccessControlPolicy;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlPolicy;
import org.apache.jackrabbit.guava.common.primitives.Ints;
import org.apache.jackrabbit.oak.commons.PathUtils;

final class PolicyComparator
implements Comparator<AccessControlPolicy> {
    PolicyComparator() {
    }

    @Override
    public int compare(AccessControlPolicy policy1, AccessControlPolicy policy2) {
        if (policy1.equals(policy2)) {
            return 0;
        }
        if (policy1 instanceof JackrabbitAccessControlPolicy && policy2 instanceof JackrabbitAccessControlPolicy) {
            return PolicyComparator.compare((JackrabbitAccessControlPolicy)policy1, (JackrabbitAccessControlPolicy)policy2);
        }
        if (policy1 instanceof JackrabbitAccessControlPolicy) {
            return -1;
        }
        if (policy2 instanceof JackrabbitAccessControlPolicy) {
            return 1;
        }
        return 0;
    }

    private static int compare(JackrabbitAccessControlPolicy policy1, JackrabbitAccessControlPolicy policy2) {
        int depth2;
        String p1 = policy1.getPath();
        String p2 = policy2.getPath();
        if (p1 == null) {
            return -1;
        }
        if (p2 == null) {
            return 1;
        }
        int depth1 = PathUtils.getDepth((String)p1);
        return depth1 == (depth2 = PathUtils.getDepth((String)p2)) ? p1.compareTo(p2) : Ints.compare((int)depth1, (int)depth2);
    }
}

