/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index;

import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.oak.api.jmx.IndexStatsMBean;
import org.jetbrains.annotations.Nullable;

public class AsyncIndexInfo {
    private final String name;
    private final long lastIndexedTo;
    private final long leaseExpiryTime;
    private final boolean running;
    private final IndexStatsMBean statsMBean;

    public AsyncIndexInfo(String name, long lastIndexedTo, long leaseExpiryTime, boolean running, @Nullable IndexStatsMBean statsMBean) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.lastIndexedTo = lastIndexedTo;
        this.leaseExpiryTime = leaseExpiryTime;
        this.running = running;
        this.statsMBean = statsMBean;
    }

    public String getName() {
        return this.name;
    }

    public long getLastIndexedTo() {
        return this.lastIndexedTo;
    }

    public long getLeaseExpiryTime() {
        return this.leaseExpiryTime;
    }

    public boolean isRunning() {
        return this.running;
    }

    @Nullable
    public IndexStatsMBean getStatsMBean() {
        return this.statsMBean;
    }

    public String toString() {
        return String.format("%s : lastIndexedTo :%tc, leaseExpiryTime :%tc, running :%s", this.name, this.lastIndexedTo, this.leaseExpiryTime, this.running);
    }
}

