/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.tool;

import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.segment.RecordId;
import org.apache.jackrabbit.oak.segment.RecordType;
import org.apache.jackrabbit.oak.segment.SegmentId;
import org.apache.jackrabbit.oak.segment.SegmentNodeState;
import org.apache.jackrabbit.oak.segment.SegmentNotFoundException;
import org.apache.jackrabbit.oak.segment.file.FileStoreBuilder;
import org.apache.jackrabbit.oak.segment.file.ReadOnlyFileStore;
import org.apache.jackrabbit.oak.segment.tool.Utils;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class SearchNodes {
    private final File path;
    private final List<Matcher> matchers;
    private final Output output;
    private final PrintStream out;
    private final PrintStream err;
    private final Set<String> notFoundSegments = new HashSet<String>();

    public static Builder builder() {
        return new Builder();
    }

    private SearchNodes(Builder builder) {
        this.path = builder.path;
        this.matchers = new ArrayList<Matcher>(builder.matchers);
        this.output = builder.output;
        this.out = builder.out;
        this.err = builder.err;
    }

    public int run() {
        try (ReadOnlyFileStore fileStore = this.newFileStore();){
            for (SegmentId segmentId : fileStore.getSegmentIds()) {
                try {
                    this.processSegment(fileStore, segmentId);
                }
                catch (SegmentNotFoundException e) {
                    this.handle(e);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace(this.err);
            return 1;
        }
        return 0;
    }

    private ReadOnlyFileStore newFileStore() throws Exception {
        return FileStoreBuilder.fileStoreBuilder(this.path).buildReadOnly();
    }

    private void processSegment(ReadOnlyFileStore fileStore, SegmentId segmentId) {
        if (segmentId.isBulkSegmentId()) {
            return;
        }
        Long timestamp = Utils.parseSegmentInfoTimestamp(segmentId);
        if (timestamp == null) {
            this.err.printf("No timestamp found in segment %s\n", segmentId);
            return;
        }
        segmentId.getSegment().forEachRecord((number, type, offset) -> {
            if (type != RecordType.NODE) {
                return;
            }
            try {
                this.processRecord(fileStore, timestamp, new RecordId(segmentId, number));
            }
            catch (SegmentNotFoundException e) {
                this.handle(e);
            }
        });
    }

    private void processRecord(ReadOnlyFileStore fileStore, long timestamp, RecordId recordId) {
        SegmentNodeState nodeState = fileStore.getReader().readNode(recordId);
        boolean matches = true;
        for (Matcher matcher : this.matchers) {
            matches = matches && matcher.matches(nodeState);
        }
        if (!matches) {
            return;
        }
        switch (this.output) {
            case TEXT: {
                this.out.printf("%d\t%s\n", timestamp, recordId);
                break;
            }
            case JOURNAL: {
                this.out.printf("%s root %d\n", recordId.toString10(), timestamp);
                break;
            }
            default: {
                throw new IllegalStateException("unrecognized output");
            }
        }
    }

    private void handle(SegmentNotFoundException e) {
        if (this.notFoundSegments.add(e.getSegmentId())) {
            e.printStackTrace(this.err);
        }
    }

    public static class Builder {
        private File path;
        private List<Matcher> matchers = new ArrayList<Matcher>();
        private Output output = Output.TEXT;
        private PrintStream out = System.out;
        private PrintStream err = System.err;

        public Builder withPath(File path) {
            this.path = path;
            return this;
        }

        public Builder withProperty(String name) {
            Preconditions.checkNotNull((Object)name, (Object)"name");
            this.matchers.add(node -> node.hasProperty(name));
            return this;
        }

        public Builder withChild(String name) {
            Preconditions.checkNotNull((Object)name, (Object)"name");
            this.matchers.add(node -> node.hasChildNode(name));
            return this;
        }

        public Builder withValue(String name, String value) {
            Preconditions.checkNotNull((Object)name, (Object)"name");
            Preconditions.checkNotNull((Object)value, (Object)"value");
            this.matchers.add(node -> {
                PropertyState p = node.getProperty(name);
                if (p == null) {
                    return false;
                }
                if (p.isArray()) {
                    for (String v : (Iterable)p.getValue(Type.STRINGS)) {
                        if (!v.equals(value)) continue;
                        return true;
                    }
                    return false;
                }
                return ((String)p.getValue(Type.STRING)).equals(value);
            });
            return this;
        }

        public Builder withOutput(Output output) {
            this.output = (Output)((Object)Preconditions.checkNotNull((Object)((Object)output), (Object)"output"));
            return this;
        }

        public Builder withOut(PrintStream out) {
            this.out = (PrintStream)Preconditions.checkNotNull((Object)out, (Object)"out");
            return this;
        }

        public Builder withErr(PrintStream err) {
            this.err = (PrintStream)Preconditions.checkNotNull((Object)err, (Object)"err");
            return this;
        }

        public SearchNodes build() {
            Preconditions.checkArgument((this.path != null ? 1 : 0) != 0, (Object)"path not specified");
            return new SearchNodes(this);
        }
    }

    public static enum Output {
        TEXT,
        JOURNAL;

    }

    private static interface Matcher {
        public boolean matches(NodeState var1);
    }
}

