/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.standby.server;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.io.InputStream;
import org.apache.jackrabbit.oak.segment.standby.codec.GetBlobRequest;
import org.apache.jackrabbit.oak.segment.standby.codec.GetBlobResponse;
import org.apache.jackrabbit.oak.segment.standby.server.StandbyBlobReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GetBlobRequestHandler
extends SimpleChannelInboundHandler<GetBlobRequest> {
    private static final Logger log = LoggerFactory.getLogger(GetBlobRequestHandler.class);
    private final StandbyBlobReader reader;

    GetBlobRequestHandler(StandbyBlobReader reader) {
        this.reader = reader;
    }

    protected void channelRead0(ChannelHandlerContext ctx, GetBlobRequest msg) throws Exception {
        log.debug("Reading blob {} for client {}", (Object)msg.getBlobId(), (Object)msg.getClientId());
        InputStream in = this.reader.readBlob(msg.getBlobId());
        long length = this.reader.getBlobLength(msg.getBlobId());
        if (in == null || length == -1L) {
            log.debug("Blob {} not found, discarding request from client {}", (Object)msg.getBlobId(), (Object)msg.getClientId());
            return;
        }
        ctx.writeAndFlush((Object)new GetBlobResponse(msg.getClientId(), msg.getBlobId(), in, length));
    }
}

