/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file.proc;

import java.util.ArrayList;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.memory.MemoryChildNodeEntry;
import org.apache.jackrabbit.oak.segment.file.proc.AbstractNode;
import org.apache.jackrabbit.oak.segment.file.proc.Proc;
import org.apache.jackrabbit.oak.segment.file.proc.TarNode;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;

class StoreNode
extends AbstractNode {
    private final Proc.Backend backend;

    StoreNode(Proc.Backend backend) {
        this.backend = backend;
    }

    @Override
    public boolean hasChildNode(@NotNull String name) {
        return this.backend.tarExists(name);
    }

    @Override
    @NotNull
    public NodeState getChildNode(@NotNull String name) throws IllegalArgumentException {
        if (this.backend.tarExists(name)) {
            return new TarNode(this.backend, name);
        }
        return EmptyNodeState.MISSING_NODE;
    }

    @Override
    @NotNull
    public Iterable<? extends ChildNodeEntry> getChildNodeEntries() {
        ArrayList<MemoryChildNodeEntry> entries = new ArrayList<MemoryChildNodeEntry>();
        for (String name : this.backend.getTarNames()) {
            entries.add(new MemoryChildNodeEntry(name, (NodeState)new TarNode(this.backend, name)));
        }
        return entries;
    }
}

