/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.gallery.constant;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import org.silverpeas.components.gallery.model.Media;
import org.silverpeas.components.gallery.model.Photo;
import org.silverpeas.components.gallery.model.Sound;
import org.silverpeas.components.gallery.model.Streaming;
import org.silverpeas.components.gallery.model.Video;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public enum MediaType {
    Unknown(null),
    Photo(Photo.class),
    Video(Video.class),
    Sound(Sound.class),
    Streaming(Streaming.class);

    private final Class<? extends Media> mediaClass;
    private final String mediaWebUriPart;

    private MediaType(Class<? extends Media> mediaClass) {
        this.mediaClass = mediaClass;
        this.mediaWebUriPart = this.name().toLowerCase() + "s";
    }

    @JsonCreator
    public static MediaType from(String type) {
        try {
            return MediaType.valueOf(StringUtil.capitalize((String)type));
        }
        catch (Exception e) {
            SilverLogger.getLogger(MediaType.class).warn((Throwable)e);
            return Unknown;
        }
    }

    @JsonValue
    public String getName() {
        return this.name();
    }

    public <M extends Media> M newInstance() {
        try {
            return (M)this.mediaClass.newInstance();
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)((Object)this)).warn((Throwable)e);
            return null;
        }
    }

    public boolean isPhoto() {
        return Photo == this;
    }

    public boolean isVideo() {
        return Video == this;
    }

    public boolean isSound() {
        return Sound == this;
    }

    public boolean isStreaming() {
        return Streaming == this;
    }

    public String getTechnicalFolder() {
        if (this == Photo) {
            return "image";
        }
        return this.name().toLowerCase();
    }

    public String getMediaWebUriPart() {
        return this.mediaWebUriPart;
    }
}

