/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.commit;

import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.spi.commit.PartialConflictHandler;
import org.apache.jackrabbit.oak.spi.commit.ThreeWayConflictHandler;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConflictHandlers {
    private ConflictHandlers() {
    }

    @NotNull
    public static ThreeWayConflictHandler wrap(@NotNull PartialConflictHandler handler) {
        return new ThreeWayConflictHandlerWrapper(handler);
    }

    @NotNull
    private static ThreeWayConflictHandler.Resolution wrap(@Nullable PartialConflictHandler.Resolution r) {
        if (r == null) {
            return ThreeWayConflictHandler.Resolution.IGNORED;
        }
        switch (r) {
            case OURS: {
                return ThreeWayConflictHandler.Resolution.OURS;
            }
            case THEIRS: {
                return ThreeWayConflictHandler.Resolution.THEIRS;
            }
            case MERGED: {
                return ThreeWayConflictHandler.Resolution.MERGED;
            }
        }
        return ThreeWayConflictHandler.Resolution.IGNORED;
    }

    private static class ThreeWayConflictHandlerWrapper
    implements ThreeWayConflictHandler {
        private final PartialConflictHandler handler;

        public ThreeWayConflictHandlerWrapper(@NotNull PartialConflictHandler handler) {
            this.handler = handler;
        }

        @Override
        @NotNull
        public ThreeWayConflictHandler.Resolution addExistingProperty(@NotNull NodeBuilder parent, @NotNull PropertyState ours, @NotNull PropertyState theirs) {
            return ConflictHandlers.wrap(this.handler.addExistingProperty(parent, ours, theirs));
        }

        @Override
        @NotNull
        public ThreeWayConflictHandler.Resolution changeDeletedProperty(@NotNull NodeBuilder parent, @NotNull PropertyState ours, @NotNull PropertyState base) {
            return ConflictHandlers.wrap(this.handler.changeDeletedProperty(parent, ours));
        }

        @Override
        @NotNull
        public ThreeWayConflictHandler.Resolution changeChangedProperty(@NotNull NodeBuilder parent, @NotNull PropertyState ours, @NotNull PropertyState theirs, @NotNull PropertyState base) {
            return ConflictHandlers.wrap(this.handler.changeChangedProperty(parent, ours, theirs));
        }

        @Override
        @NotNull
        public ThreeWayConflictHandler.Resolution deleteDeletedProperty(@NotNull NodeBuilder parent, @NotNull PropertyState base) {
            return ConflictHandlers.wrap(this.handler.deleteDeletedProperty(parent, base));
        }

        @Override
        @NotNull
        public ThreeWayConflictHandler.Resolution deleteChangedProperty(@NotNull NodeBuilder parent, @NotNull PropertyState theirs, @NotNull PropertyState base) {
            return ConflictHandlers.wrap(this.handler.deleteChangedProperty(parent, theirs));
        }

        @Override
        @NotNull
        public ThreeWayConflictHandler.Resolution addExistingNode(@NotNull NodeBuilder parent, @NotNull String name, @NotNull NodeState ours, @NotNull NodeState theirs) {
            return ConflictHandlers.wrap(this.handler.addExistingNode(parent, name, ours, theirs));
        }

        @Override
        @NotNull
        public ThreeWayConflictHandler.Resolution changeDeletedNode(@NotNull NodeBuilder parent, @NotNull String name, @NotNull NodeState ours, @NotNull NodeState base) {
            return ConflictHandlers.wrap(this.handler.changeDeletedNode(parent, name, ours));
        }

        @Override
        @NotNull
        public ThreeWayConflictHandler.Resolution deleteChangedNode(@NotNull NodeBuilder parent, @NotNull String name, @NotNull NodeState theirs, @NotNull NodeState base) {
            return ConflictHandlers.wrap(this.handler.deleteChangedNode(parent, name, theirs));
        }

        @Override
        @NotNull
        public ThreeWayConflictHandler.Resolution deleteDeletedNode(@NotNull NodeBuilder parent, @NotNull String name, @NotNull NodeState base) {
            return ConflictHandlers.wrap(this.handler.deleteDeletedNode(parent, name));
        }
    }
}

