/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file;

import java.util.Arrays;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.guava.common.base.Predicate;
import org.apache.jackrabbit.guava.common.base.Supplier;
import org.apache.jackrabbit.guava.common.cache.CacheStats;
import org.apache.jackrabbit.guava.common.cache.Weigher;
import org.apache.jackrabbit.oak.segment.CacheWeights;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PriorityCache<K, V> {
    private final int rehash;
    private final Entry<?, ?>[] entries;
    private final int[] costs = new int[256];
    private final int[] evictions = new int[256];
    private long hitCount;
    private long missCount;
    private long loadCount;
    private long loadExceptionCount;
    private long evictionCount;
    private long size;
    @NotNull
    private final Weigher<K, V> weigher;
    private long weight = 0L;

    public static <K, V> Supplier<PriorityCache<K, V>> factory(final int size, final @NotNull Weigher<K, V> weigher) {
        Preconditions.checkArgument((Integer.bitCount(size) == 1 ? 1 : 0) != 0);
        Preconditions.checkNotNull(weigher);
        return new Supplier<PriorityCache<K, V>>(){

            public PriorityCache<K, V> get() {
                return new PriorityCache(size, weigher);
            }
        };
    }

    public static <K, V> Supplier<PriorityCache<K, V>> factory(final int size) {
        Preconditions.checkArgument((Integer.bitCount(size) == 1 ? 1 : 0) != 0);
        return new Supplier<PriorityCache<K, V>>(){

            public PriorityCache<K, V> get() {
                return new PriorityCache(size);
            }
        };
    }

    public static long nextPowerOfTwo(int size) {
        return 1L << (int)(64L - (long)Long.numberOfLeadingZeros((long)Math.max(1, size) - 1L));
    }

    PriorityCache(int size, int rehash) {
        this(size, rehash, CacheWeights.noopWeigher());
    }

    public PriorityCache(int size, int rehash, @NotNull Weigher<K, V> weigher) {
        Preconditions.checkArgument((Integer.bitCount(size) == 1 ? 1 : 0) != 0);
        Preconditions.checkArgument((rehash >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((rehash < 32 - Integer.numberOfTrailingZeros(size) ? 1 : 0) != 0);
        this.rehash = rehash;
        this.entries = new Entry[size];
        Arrays.fill(this.entries, Entry.NULL);
        this.weigher = (Weigher)Preconditions.checkNotNull(weigher);
    }

    public PriorityCache(int size, @NotNull Weigher<K, V> weigher) {
        this(size, 31 - Integer.numberOfTrailingZeros(size), weigher);
    }

    public PriorityCache(int size) {
        this(size, 31 - Integer.numberOfTrailingZeros(size));
    }

    private int project(int hashCode, int iteration) {
        return hashCode >> iteration & this.entries.length - 1;
    }

    public long size() {
        return this.size;
    }

    public synchronized boolean put(@NotNull K key, @NotNull V value, int generation, byte initialCost) {
        int hashCode = key.hashCode();
        byte cheapest = initialCost;
        int index = -1;
        boolean eviction = false;
        for (int k = 0; k <= this.rehash; ++k) {
            int i = this.project(hashCode, k);
            Entry<?, ?> entry = this.entries[i];
            if (entry == Entry.NULL) {
                index = i;
                eviction = false;
                break;
            }
            if (entry.generation <= generation && key.equals(entry.key)) {
                index = i;
                initialCost = entry.cost;
                if (initialCost < 127) {
                    initialCost = (byte)(initialCost + 1);
                }
                eviction = false;
                break;
            }
            if (entry.generation < generation) {
                index = i;
                eviction = false;
                break;
            }
            if (entry.cost >= cheapest) continue;
            cheapest = entry.cost;
            index = i;
            eviction = true;
        }
        if (index >= 0) {
            Entry<?, ?> old = this.entries[index];
            Entry<K, V> newE = new Entry<K, V>(key, value, generation, initialCost);
            this.entries[index] = newE;
            ++this.loadCount;
            int n = initialCost - -128;
            this.costs[n] = this.costs[n] + 1;
            if (old != Entry.NULL) {
                int n2 = old.cost - -128;
                this.costs[n2] = this.costs[n2] - 1;
                if (eviction) {
                    int n3 = old.cost - -128;
                    this.evictions[n3] = this.evictions[n3] + 1;
                    ++this.evictionCount;
                }
                this.weight -= (long)this.weighEntry(old);
            } else {
                ++this.size;
            }
            this.weight += (long)this.weighEntry(newE);
            return true;
        }
        ++this.loadExceptionCount;
        return false;
    }

    @Nullable
    public synchronized V get(@NotNull K key, int generation) {
        int hashCode = key.hashCode();
        for (int k = 0; k <= this.rehash; ++k) {
            int i = this.project(hashCode, k);
            Entry<?, ?> entry = this.entries[i];
            if (generation != entry.generation || !key.equals(entry.key)) continue;
            if (entry.cost < 127) {
                int n = entry.cost - -128;
                this.costs[n] = this.costs[n] - 1;
                entry.cost = (byte)(entry.cost + 1);
                int n2 = entry.cost - -128;
                this.costs[n2] = this.costs[n2] + 1;
            }
            ++this.hitCount;
            return entry.value;
        }
        ++this.missCount;
        return null;
    }

    public synchronized void purgeGenerations(@NotNull Predicate<Integer> purge) {
        for (int i = 0; i < this.entries.length; ++i) {
            Entry<?, ?> entry = this.entries[i];
            if (entry == Entry.NULL || !purge.apply((Object)entry.generation)) continue;
            this.entries[i] = Entry.NULL;
            --this.size;
            this.weight -= (long)this.weighEntry(entry);
        }
    }

    private int weighEntry(Entry<?, ?> entry) {
        return this.weigher.weigh(entry.key, entry.value);
    }

    public synchronized String toString() {
        return "PriorityCache{ costs=" + PriorityCache.toString(this.costs) + ", evictions=" + PriorityCache.toString(this.evictions) + " }";
    }

    private static String toString(int[] ints) {
        StringBuilder b = new StringBuilder("[");
        String sep = "";
        for (int i = 0; i < ints.length; ++i) {
            if (ints[i] <= 0) continue;
            b.append(sep).append(i).append("->").append(ints[i]);
            sep = ",";
        }
        return b.append(']').toString();
    }

    @NotNull
    public CacheStats getStats() {
        return new CacheStats(this.hitCount, this.missCount, this.loadCount, this.loadExceptionCount, 0L, this.evictionCount);
    }

    public long estimateCurrentWeight() {
        return this.weight;
    }

    private static class Entry<K, V> {
        static final Entry<Void, Void> NULL = new Entry<Object, Object>(null, null, -1, -128);
        final K key;
        final V value;
        final int generation;
        byte cost;

        public Entry(K key, V value, int generation, byte cost) {
            this.key = key;
            this.value = value;
            this.generation = generation;
            this.cost = cost;
        }

        public String toString() {
            return this == NULL ? "NULL" : "Entry{" + this.key + "->" + this.value + " @" + this.generation + ", $" + this.cost + "}";
        }
    }
}

