/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.observation;

import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.spi.commit.CommitContext;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.EditorProvider;
import org.apache.jackrabbit.oak.spi.commit.Validator;
import org.apache.jackrabbit.oak.spi.commit.ValidatorProvider;
import org.apache.jackrabbit.oak.spi.observation.ChangeSet;
import org.apache.jackrabbit.oak.spi.observation.ChangeSetBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={ValidatorProvider.class, EditorProvider.class}, property={"type=changeCollectorProvider"})
@Designate(ocd=Configuration.class)
public class ChangeCollectorProvider
extends ValidatorProvider {
    private static final int DEFAULT_MAX_ITEMS = 50;
    private static final int DEFAULT_MAX_PATH_DEPTH = 9;
    private static final boolean DEFAULT_ENABLED = true;
    public static final String TYPE = "changeCollectorProvider";
    private static final Logger LOG = LoggerFactory.getLogger(ChangeCollectorProvider.class);
    public static final String COMMIT_CONTEXT_OBSERVATION_CHANGESET = "oak.observation.changeSet";
    private int maxItems = 50;
    private int maxPathDepth = 9;
    private boolean enabled = true;

    @Activate
    protected void activate(Configuration config) {
        this.reconfig(config);
        LOG.info("activate: maxItems=" + this.maxItems + ", maxPathDepth=" + this.maxPathDepth + ", enabled=" + this.enabled);
    }

    @Modified
    protected void modified(Configuration config) {
        this.reconfig(config);
        LOG.info("modified: maxItems=" + this.maxItems + ", maxPathDepth=" + this.maxPathDepth + ", enabled=" + this.enabled);
    }

    private void reconfig(Configuration config) {
        this.maxItems = config.maxItems();
        this.maxPathDepth = config.maxPathDepth();
        this.enabled = config.enabled();
    }

    protected void setMaxPathDepth(int maxPathDepth) {
        this.maxPathDepth = maxPathDepth;
    }

    protected int getMaxPathDepth() {
        return this.maxPathDepth;
    }

    protected void setMaxItems(int maxItems) {
        this.maxItems = maxItems;
    }

    protected int getMaxItems() {
        return this.maxItems;
    }

    protected Validator getRootValidator(NodeState before, NodeState after, CommitInfo info) {
        if (!this.enabled) {
            return null;
        }
        if (info == null || !info.getInfo().containsKey("oak.commitAttributes")) {
            return null;
        }
        return ChangeCollector.newRootCollector(info, this.maxItems, this.maxPathDepth);
    }

    private static class ChangeCollector
    implements Validator {
        private final CollectorSupport support;
        private final boolean isRoot;
        private final NodeState beforeParentNodeOrNull;
        private final NodeState afterParentNodeOrNull;
        private final String path;
        private final String childName;
        private final int level;
        private boolean changed;

        private static ChangeCollector newRootCollector(@NotNull CommitInfo info, int maxItems, int maxPathDepth) {
            ChangeSetBuilder changeSetBuilder = new ChangeSetBuilder(maxItems, maxPathDepth);
            CollectorSupport support = new CollectorSupport(info, changeSetBuilder, maxPathDepth);
            return new ChangeCollector(support, true, null, null, "/", null, 0);
        }

        private ChangeCollector newChildCollector(@Nullable NodeState beforeParentNodeOrNull, @Nullable NodeState afterParentNodeOrNull, @NotNull String childName) {
            return new ChangeCollector(this.support, false, beforeParentNodeOrNull, afterParentNodeOrNull, PathUtils.concat((String)this.path, (String)childName), childName, this.level + 1);
        }

        private ChangeCollector(@NotNull CollectorSupport support, boolean isRoot, @Nullable NodeState beforeParentNodeOrNull, @Nullable NodeState afterParentNodeOrNull, @NotNull String path, @Nullable String childNameOrNull, int level) {
            this.support = support;
            this.isRoot = isRoot;
            this.beforeParentNodeOrNull = beforeParentNodeOrNull;
            this.afterParentNodeOrNull = afterParentNodeOrNull;
            this.path = path;
            this.childName = childNameOrNull;
            this.level = level;
        }

        public String toString() {
            return "ChangeCollector[path=" + this.path + "]";
        }

        public void enter(NodeState before, NodeState after) throws CommitFailedException {
        }

        public void leave(NodeState before, NodeState after) throws CommitFailedException {
            if (this.changed && this.level <= this.support.maxPathDepth) {
                this.support.changeSetBuilder.addParentPath(this.path);
            }
            if (this.changed && this.childName != null) {
                this.support.changeSetBuilder.addParentNodeName(this.childName);
            }
            if (this.changed) {
                this.addParentNodeType(this.beforeParentNodeOrNull);
                this.addParentNodeType(this.afterParentNodeOrNull);
            }
            if (!this.isRoot) {
                return;
            }
            CommitContext commitContext = (CommitContext)this.support.info.getInfo().get("oak.commitAttributes");
            ChangeSet changeSet = this.support.changeSetBuilder.build();
            commitContext.set(ChangeCollectorProvider.COMMIT_CONTEXT_OBSERVATION_CHANGESET, (Object)changeSet);
            LOG.debug("Collected changeSet for commit {} is {}", (Object)this.support.info, (Object)changeSet);
        }

        public void propertyAdded(PropertyState after) throws CommitFailedException {
            this.addPropertyName(after);
        }

        public void propertyChanged(PropertyState before, PropertyState after) throws CommitFailedException {
            this.addPropertyName(before);
        }

        public void propertyDeleted(PropertyState before) throws CommitFailedException {
            this.addPropertyName(before);
        }

        public Validator childNodeAdded(String childName, NodeState after) throws CommitFailedException {
            this.changed = true;
            this.addToAllNodeType(after);
            return this.newChildCollector(null, after, childName);
        }

        public Validator childNodeChanged(String childName, NodeState before, NodeState after) throws CommitFailedException {
            if (this.level == this.support.maxPathDepth) {
                this.support.changeSetBuilder.addParentPath(this.path);
            }
            this.addToAllNodeType(before);
            this.addToAllNodeType(after);
            return this.newChildCollector(before, after, childName);
        }

        public Validator childNodeDeleted(String childName, NodeState before) throws CommitFailedException {
            this.changed = true;
            this.addToAllNodeType(before);
            return this.newChildCollector(before, null, childName);
        }

        private void addToAllNodeType(NodeState state) {
            String primaryType = state.getName("jcr:primaryType");
            if (primaryType != null) {
                this.support.changeSetBuilder.addNodeType(primaryType);
            }
            this.support.changeSetBuilder.addNodeTypes(state.getNames("jcr:mixinTypes"));
        }

        private void addParentNodeType(@Nullable NodeState state) {
            if (state == null) {
                return;
            }
            String primaryType = state.getName("jcr:primaryType");
            if (primaryType != null) {
                this.support.changeSetBuilder.addParentNodeType(primaryType);
            }
            this.support.changeSetBuilder.addParentNodeTypes(state.getNames("jcr:mixinTypes"));
        }

        private void addPropertyName(PropertyState after) {
            this.changed = true;
            this.support.changeSetBuilder.addPropertyName(after.getName());
        }
    }

    private static class CollectorSupport {
        final CommitInfo info;
        final int maxPathDepth;
        final ChangeSetBuilder changeSetBuilder;

        public CollectorSupport(@NotNull CommitInfo info, @NotNull ChangeSetBuilder changeSetBuilder, int maxPathDepth) {
            this.info = info;
            this.changeSetBuilder = changeSetBuilder;
            this.maxPathDepth = maxPathDepth;
        }

        public String toString() {
            return "CollectorSupport with " + this.changeSetBuilder;
        }
    }

    @ObjectClassDefinition(name="Apache Jackrabbit Oak Change Collector Service", description="It hooks into the commit and collects a ChangeSet of changed items of a commit which is then used to speed up observation processing")
    static @interface Configuration {
        @AttributeDefinition(name="Maximum Number of Collected Items (per type)", description="Integer value indicating maximum number of individual items of changes - such as property, nodeType, node name, path - to be collected. If there are more changes, the collection is considered failed and marked as such. Default is 50")
        public int maxItems() default 50;

        @AttributeDefinition(name="Maximum depth of paths to collect", description="Integer value indicating maximum depth of paths to collect. Paths deeper than this will not be individually reported, and instead a path at this max depth will be added. Note that this doesn't affect any other collected item such as property, nodeType - ie those will all be collected irrespective of this config param.Default is 9")
        public int maxPathDepth() default 9;

        @AttributeDefinition(name="enable/disable this validator", description="Whether this validator is enabled. If disabled no ChangeSet will be generated. Default is true")
        public boolean enabled() default true;
    }
}

