/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.setup.api;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.File;
import java.io.InvalidObjectException;
import java.lang.ref.SoftReference;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.SystemUtils;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.silverpeas.setup.api.FileLogger;
import org.silverpeas.setup.api.SystemWrapper;

public class JBossServer
implements GroovyObject {
    private static long DEFAULT_TIMEOUT;
    private String cli;
    private String starter;
    private final String jbossHome;
    private boolean serverManagementAllIP;
    private File redirection;
    private long timeout;
    private FileLogger logger;
    private static /* synthetic */ long $const$0;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    public JBossServer(String jbossHome) {
        String string;
        MetaClass metaClass;
        CallSite[] callSiteArray = JBossServer.$getCallSiteArray();
        Object var3_3 = null;
        this.redirection = (File)ScriptBytecodeAdapter.castToType(var3_3, File.class);
        long l = DEFAULT_TIMEOUT;
        this.timeout = l;
        Object object = callSiteArray[0].call(FileLogger.class, callSiteArray[1].call(callSiteArray[2].callCurrent((GroovyObject)this)), callSiteArray[3].callGetProperty(System.class));
        this.logger = (FileLogger)ScriptBytecodeAdapter.castToType((Object)object, FileLogger.class);
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.jbossHome = string = jbossHome;
        if (ScriptBytecodeAdapter.compareGreaterThanEqual((Object)callSiteArray[4].call(callSiteArray[5].call(callSiteArray[6].call(SystemWrapper.class, (Object)"os.name")), (Object)"win"), (Object)0)) {
            GStringImpl gStringImpl = new GStringImpl(new Object[]{jbossHome}, new String[]{"", "/bin/jboss-cli.bat"});
            this.cli = ShortTypeHandling.castToString((Object)gStringImpl);
            GStringImpl gStringImpl2 = new GStringImpl(new Object[]{jbossHome}, new String[]{"", "/bin/standalone.bat"});
            this.starter = ShortTypeHandling.castToString((Object)gStringImpl2);
        } else {
            GStringImpl gStringImpl = new GStringImpl(new Object[]{jbossHome}, new String[]{"", "/bin/jboss-cli.sh"});
            this.cli = ShortTypeHandling.castToString((Object)gStringImpl);
            GStringImpl gStringImpl3 = new GStringImpl(new Object[]{jbossHome}, new String[]{"", "/bin/standalone.sh"});
            this.starter = ShortTypeHandling.castToString((Object)gStringImpl3);
        }
    }

    private void assertJBossIsRunning() {
        CallSite[] callSiteArray = JBossServer.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[7].callCurrent((GroovyObject)this))) {
                throw (Throwable)callSiteArray[8].callConstructor(AssertionError.class, (Object)"JBoss not running");
            }
        } else if (!this.isRunning()) {
            throw (Throwable)callSiteArray[9].callConstructor(AssertionError.class, (Object)"JBoss not running");
        }
    }

    private static void assertCommandSucceeds(Object command) throws AssertionError, InvalidObjectException {
        CallSite[] callSiteArray = JBossServer.$getCallSiteArray();
        String result = ShortTypeHandling.castToString((Object)callSiteArray[10].callGetProperty(callSiteArray[11].callGetProperty(command)));
        if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[12].call(command), (Object)0) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[13].call((Object)result, (Object)"\"outcome\" => \"failed\""))) {
            boolean rollBacked = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[14].call((Object)result, (Object)"\"rolled-back\" => true"));
            String msg = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{result}, new String[]{"Execution Output: \n", ""}));
            if (!rollBacked) {
                throw (Throwable)callSiteArray[15].callConstructor(InvalidObjectException.class, (Object)msg);
            }
            throw (Throwable)callSiteArray[16].callConstructor(AssertionError.class, (Object)msg);
        }
    }

    private void waitUntilRunning() {
        CallSite[] callSiteArray = JBossServer.$getCallSiteArray();
        callSiteArray[17].call((Object)this.logger, (Object)" %s", (Object)".");
        String status = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[18].callCurrent((GroovyObject)this);
            status = ShortTypeHandling.castToString((Object)object);
        } else {
            String string;
            status = string = this.status();
        }
        long start = DefaultTypeTransformation.longUnbox((Object)callSiteArray[19].call(System.class));
        while (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[20].callStatic(JBossServer.class, (Object)status))) {
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[21].callStatic(JBossServer.class, (Object)status))) {
                callSiteArray[22].callCurrent((GroovyObject)this);
            }
            callSiteArray[23].call(Thread.class, (Object)1000);
            if (ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[24].call(callSiteArray[25].call(System.class), (Object)start), (Object)this.timeout)) {
                callSiteArray[26].call((Object)this.logger, (Object)"JBoss doesn't respond. Stop all");
                throw (Throwable)callSiteArray[27].callConstructor(TimeoutException.class, (Object)"JBoss doesn't respond. Stop all");
            }
            callSiteArray[28].call((Object)this.logger, (Object)"%s", (Object)".");
            Object object = callSiteArray[29].callCurrent((GroovyObject)this);
            status = ShortTypeHandling.castToString((Object)object);
        }
    }

    public void doWhenRunning(Closure action) {
        CallSite[] callSiteArray = JBossServer.$getCallSiteArray();
        String status = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[30].callCurrent((GroovyObject)this);
            status = ShortTypeHandling.castToString((Object)object);
        } else {
            String string;
            status = string = this.status();
        }
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[31].callStatic(JBossServer.class, (Object)status))) {
                callSiteArray[32].call((Object)this.logger, (Object)"JBoss not started, so start it");
                callSiteArray[33].callCurrent((GroovyObject)this);
            } else if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[34].callStatic(JBossServer.class, (Object)status))) {
                callSiteArray[35].call((Object)this.logger, (Object)"JBoss is starting, so wait for it is running");
                callSiteArray[36].callCurrent((GroovyObject)this);
            } else if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[37].callStatic(JBossServer.class, (Object)status))) {
                callSiteArray[38].call((Object)this.logger, (Object)"JBoss asks for reload, so reloads it");
                Object proc = callSiteArray[39].call((Object)new GStringImpl(new Object[]{this.cli}, new String[]{"", " --connect --command=:reload"}));
                callSiteArray[40].call(proc);
                callSiteArray[41].callCurrent((GroovyObject)this);
            }
        } else if (JBossServer.stopped(status)) {
            callSiteArray[42].call((Object)this.logger, (Object)"JBoss not started, so start it");
            this.start();
        } else if (JBossServer.starting(status)) {
            callSiteArray[43].call((Object)this.logger, (Object)"JBoss is starting, so wait for it is running");
            this.waitUntilRunning();
        } else if (JBossServer.reloadRequired(status)) {
            callSiteArray[44].call((Object)this.logger, (Object)"JBoss asks for reload, so reloads it");
            Object proc = callSiteArray[45].call((Object)new GStringImpl(new Object[]{this.cli}, new String[]{"", " --connect --command=:reload"}));
            callSiteArray[46].call(proc);
            this.waitUntilRunning();
        }
        callSiteArray[47].call((Object)action);
    }

    public JBossServer redirectOutputTo(File log) {
        File file;
        CallSite[] callSiteArray = JBossServer.$getCallSiteArray();
        this.redirection = file = log;
        return this;
    }

    public JBossServer useLogger(Object logger) {
        CallSite[] callSiteArray = JBossServer.$getCallSiteArray();
        Object object = logger;
        this.logger = (FileLogger)ScriptBytecodeAdapter.castToType((Object)object, FileLogger.class);
        return this;
    }

    public JBossServer withStartingTimeout(long timeout) {
        CallSite[] callSiteArray = JBossServer.$getCallSiteArray();
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigL() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (timeout > (long)0) {
                long l = timeout;
                this.timeout = l;
            }
        } else if (timeout > (long)0) {
            long l = timeout;
            this.timeout = l;
        }
        return this;
    }

    public JBossServer setServerManagementAllIP(boolean isAllIp) {
        boolean bl;
        CallSite[] callSiteArray = JBossServer.$getCallSiteArray();
        this.serverManagementAllIP = bl = isAllIp;
        return this;
    }

    public String about() {
        CallSite[] callSiteArray = JBossServer.$getCallSiteArray();
        Object proc = callSiteArray[48].call((Object)new GStringImpl(new Object[]{this.cli}, new String[]{"", " --connect --commands=:read-attribute(name=product-name),:read-attribute(name=product-version)"}));
        callSiteArray[49].call(proc);
        Reference about = new Reference((Object)"");
        if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[50].call(proc), (Object)0)) {
            String output = ShortTypeHandling.castToString((Object)callSiteArray[51].callGetProperty(callSiteArray[52].callGetProperty(proc)));
            Matcher matcher = (Matcher)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.findRegex((Object)output, (Object)"\"result\" => \"(.+)\""), Matcher.class);
            public final class _about_closure1
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference about;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _about_closure1(Object _outerInstance, Object _thisObject, Reference about) {
                    Reference reference;
                    CallSite[] callSiteArray = _about_closure1.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.about = reference = about;
                }

                public Object doCall(Object token) {
                    CallSite[] callSiteArray = _about_closure1.$getCallSiteArray();
                    Object object = callSiteArray[0].call(this.about.get(), callSiteArray[1].call(callSiteArray[2].call(token, (Object)1), (Object)" "));
                    this.about.set((Object)ShortTypeHandling.castToString((Object)object));
                    return object;
                }

                @Generated
                public String getAbout() {
                    CallSite[] callSiteArray = _about_closure1.$getCallSiteArray();
                    return ShortTypeHandling.castToString((Object)this.about.get());
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _about_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "plus";
                    stringArray[1] = "plus";
                    stringArray[2] = "getAt";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[3];
                    _about_closure1.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_about_closure1.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _about_closure1.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            callSiteArray[53].call((Object)matcher, (Object)new _about_closure1(this, this, about));
        }
        return ShortTypeHandling.castToString((Object)(DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[54].callGetProperty((Object)((String)about.get()))) ? "Unsupported or unknown application server" : callSiteArray[55].call((Object)((String)about.get()))));
    }

    public void start(Map params) {
        CallSite[] callSiteArray = JBossServer.$getCallSiteArray();
        int managementPort = 9990;
        boolean adminOnly = DefaultTypeTransformation.booleanUnbox((Object)(ScriptBytecodeAdapter.compareNotEqual((Object)params, null) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[56].callGetProperty((Object)params)) ? callSiteArray[57].callGetProperty((Object)params) : Boolean.valueOf(false)));
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[58].callStatic(JBossServer.class, callSiteArray[59].callCurrent((GroovyObject)this)))) {
                callSiteArray[60].callCurrent((GroovyObject)this);
                callSiteArray[61].callCurrent((GroovyObject)this);
            }
        } else if (JBossServer.reloadRequired(this.status())) {
            this.reload();
            this.stop();
        }
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[62].callCurrent((GroovyObject)this))) {
                ProcessBuilder process = null;
                if (adminOnly) {
                    Object object = callSiteArray[63].callConstructor(ProcessBuilder.class, (Object)this.starter, (Object)"-c", (Object)"standalone-full.xml", (Object)"--admin-only");
                    process = (ProcessBuilder)ScriptBytecodeAdapter.castToType((Object)object, ProcessBuilder.class);
                } else if (this.serverManagementAllIP) {
                    Object object = callSiteArray[64].callConstructor(ProcessBuilder.class, ArrayUtil.createArray((Object)this.starter, (Object)"-c", (Object)"standalone-full.xml", (Object)"-bmanagement", (Object)"0.0.0.0", (Object)"-b", (Object)"0.0.0.0"));
                    process = (ProcessBuilder)ScriptBytecodeAdapter.castToType((Object)object, ProcessBuilder.class);
                } else {
                    Object object = callSiteArray[65].callConstructor(ProcessBuilder.class, ArrayUtil.createArray((Object)this.starter, (Object)"-c", (Object)"standalone-full.xml", (Object)"-b", (Object)"0.0.0.0"));
                    process = (ProcessBuilder)ScriptBytecodeAdapter.castToType((Object)object, ProcessBuilder.class);
                }
                callSiteArray[66].call(callSiteArray[67].call((Object)process, callSiteArray[68].callConstructor(File.class, (Object)this.jbossHome)), (Object)true);
                if (ScriptBytecodeAdapter.compareNotEqual((Object)this.redirection, null)) {
                    callSiteArray[69].call((Object)process, (Object)this.redirection);
                } else {
                    callSiteArray[70].call((Object)process);
                    callSiteArray[71].call(System.class, callSiteArray[72].call((Object)process));
                }
                callSiteArray[73].call((Object)process);
                callSiteArray[74].callCurrent((GroovyObject)this);
                if (this.serverManagementAllIP) {
                    callSiteArray[75].callCurrent((GroovyObject)this, (Object)"");
                    callSiteArray[76].callCurrent((GroovyObject)this, (Object)new GStringImpl(new Object[]{managementPort}, new String[]{"Silverpeas management console is accessible at server IP on port ", ""}));
                }
            } else {
                callSiteArray[77].call((Object)this.logger, (Object)"A JBoss instance is already started");
            }
        } else if (!this.isStartingOrRunning()) {
            ProcessBuilder process = null;
            if (adminOnly) {
                Object object = callSiteArray[78].callConstructor(ProcessBuilder.class, (Object)this.starter, (Object)"-c", (Object)"standalone-full.xml", (Object)"--admin-only");
                process = (ProcessBuilder)ScriptBytecodeAdapter.castToType((Object)object, ProcessBuilder.class);
            } else if (this.serverManagementAllIP) {
                Object object = callSiteArray[79].callConstructor(ProcessBuilder.class, ArrayUtil.createArray((Object)this.starter, (Object)"-c", (Object)"standalone-full.xml", (Object)"-bmanagement", (Object)"0.0.0.0", (Object)"-b", (Object)"0.0.0.0"));
                process = (ProcessBuilder)ScriptBytecodeAdapter.castToType((Object)object, ProcessBuilder.class);
            } else {
                Object object = callSiteArray[80].callConstructor(ProcessBuilder.class, ArrayUtil.createArray((Object)this.starter, (Object)"-c", (Object)"standalone-full.xml", (Object)"-b", (Object)"0.0.0.0"));
                process = (ProcessBuilder)ScriptBytecodeAdapter.castToType((Object)object, ProcessBuilder.class);
            }
            callSiteArray[81].call(callSiteArray[82].call((Object)process, callSiteArray[83].callConstructor(File.class, (Object)this.jbossHome)), (Object)true);
            if (ScriptBytecodeAdapter.compareNotEqual((Object)this.redirection, null)) {
                callSiteArray[84].call((Object)process, (Object)this.redirection);
            } else {
                callSiteArray[85].call((Object)process);
                callSiteArray[86].call(System.class, callSiteArray[87].call((Object)process));
            }
            callSiteArray[88].call((Object)process);
            this.waitUntilRunning();
            if (this.serverManagementAllIP) {
                callSiteArray[89].callCurrent((GroovyObject)this, (Object)"");
                callSiteArray[90].callCurrent((GroovyObject)this, (Object)new GStringImpl(new Object[]{managementPort}, new String[]{"Silverpeas management console is accessible at server IP on port ", ""}));
            }
        } else {
            callSiteArray[91].call((Object)this.logger, (Object)"A JBoss instance is already started");
        }
    }

    public void debug(int port) {
        CallSite[] callSiteArray = JBossServer.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[92].callStatic(JBossServer.class, callSiteArray[93].callCurrent((GroovyObject)this)))) {
                callSiteArray[94].callCurrent((GroovyObject)this);
                callSiteArray[95].callCurrent((GroovyObject)this);
            }
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[96].callCurrent((GroovyObject)this))) {
                int managementPort = 9990;
                String p = ShortTypeHandling.castToString((Object)(port <= 1000 ? "5005" : callSiteArray[97].call(String.class, (Object)port)));
                ProcessBuilder process = null;
                if (this.serverManagementAllIP) {
                    Object object = callSiteArray[98].call(callSiteArray[99].call(callSiteArray[100].callConstructor(ProcessBuilder.class, ArrayUtil.createArray((Object)this.starter, (Object)"-c", (Object)"standalone-full.xml", (Object)"-bmanagement", (Object)"0.0.0.0", (Object)"-b", (Object)"0.0.0.0", (Object)"--debug", (Object)p)), callSiteArray[101].callConstructor(File.class, (Object)this.jbossHome)), (Object)true);
                    process = (ProcessBuilder)ScriptBytecodeAdapter.castToType((Object)object, ProcessBuilder.class);
                } else {
                    Object object = callSiteArray[102].call(callSiteArray[103].call(callSiteArray[104].callConstructor(ProcessBuilder.class, ArrayUtil.createArray((Object)this.starter, (Object)"-c", (Object)"standalone-full.xml", (Object)"-b", (Object)"0.0.0.0", (Object)"--debug", (Object)p)), callSiteArray[105].callConstructor(File.class, (Object)this.jbossHome)), (Object)true);
                    process = (ProcessBuilder)ScriptBytecodeAdapter.castToType((Object)object, ProcessBuilder.class);
                }
                if (ScriptBytecodeAdapter.compareNotEqual((Object)this.redirection, null)) {
                    callSiteArray[106].call((Object)process, (Object)this.redirection);
                } else {
                    callSiteArray[107].call((Object)process);
                    callSiteArray[108].call(System.class, callSiteArray[109].call((Object)process));
                }
                callSiteArray[110].call((Object)process);
                callSiteArray[111].callCurrent((GroovyObject)this);
                callSiteArray[112].callCurrent((GroovyObject)this, (Object)"");
                if (this.serverManagementAllIP) {
                    callSiteArray[113].callCurrent((GroovyObject)this, (Object)new GStringImpl(new Object[]{managementPort}, new String[]{"Silverpeas management console is accessible at server IP on port ", ""}));
                }
                callSiteArray[114].callCurrent((GroovyObject)this, (Object)new GStringImpl(new Object[]{p}, new String[]{"Silverpeas Debugging Port is ", ""}));
            } else {
                callSiteArray[115].call((Object)this.logger, (Object)"A JBoss instance is already started");
            }
        } else {
            if (JBossServer.reloadRequired(this.status())) {
                this.reload();
                this.stop();
            }
            if (!this.isStartingOrRunning()) {
                int managementPort = 9990;
                String p = ShortTypeHandling.castToString((Object)(port <= 1000 ? "5005" : callSiteArray[116].call(String.class, (Object)port)));
                ProcessBuilder process = null;
                if (this.serverManagementAllIP) {
                    Object object = callSiteArray[117].call(callSiteArray[118].call(callSiteArray[119].callConstructor(ProcessBuilder.class, ArrayUtil.createArray((Object)this.starter, (Object)"-c", (Object)"standalone-full.xml", (Object)"-bmanagement", (Object)"0.0.0.0", (Object)"-b", (Object)"0.0.0.0", (Object)"--debug", (Object)p)), callSiteArray[120].callConstructor(File.class, (Object)this.jbossHome)), (Object)true);
                    process = (ProcessBuilder)ScriptBytecodeAdapter.castToType((Object)object, ProcessBuilder.class);
                } else {
                    Object object = callSiteArray[121].call(callSiteArray[122].call(callSiteArray[123].callConstructor(ProcessBuilder.class, ArrayUtil.createArray((Object)this.starter, (Object)"-c", (Object)"standalone-full.xml", (Object)"-b", (Object)"0.0.0.0", (Object)"--debug", (Object)p)), callSiteArray[124].callConstructor(File.class, (Object)this.jbossHome)), (Object)true);
                    process = (ProcessBuilder)ScriptBytecodeAdapter.castToType((Object)object, ProcessBuilder.class);
                }
                if (ScriptBytecodeAdapter.compareNotEqual((Object)this.redirection, null)) {
                    callSiteArray[125].call((Object)process, (Object)this.redirection);
                } else {
                    callSiteArray[126].call((Object)process);
                    callSiteArray[127].call(System.class, callSiteArray[128].call((Object)process));
                }
                callSiteArray[129].call((Object)process);
                this.waitUntilRunning();
                callSiteArray[130].callCurrent((GroovyObject)this, (Object)"");
                if (this.serverManagementAllIP) {
                    callSiteArray[131].callCurrent((GroovyObject)this, (Object)new GStringImpl(new Object[]{managementPort}, new String[]{"Silverpeas management console is accessible at server IP on port ", ""}));
                }
                callSiteArray[132].callCurrent((GroovyObject)this, (Object)new GStringImpl(new Object[]{p}, new String[]{"Silverpeas Debugging Port is ", ""}));
            } else {
                callSiteArray[133].call((Object)this.logger, (Object)"A JBoss instance is already started");
            }
        }
    }

    public void stop() {
        CallSite[] callSiteArray = JBossServer.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[134].callCurrent((GroovyObject)this))) {
                Object proc = callSiteArray[135].call((Object)new GStringImpl(new Object[]{this.cli}, new String[]{"", " --connect --command=:shutdown"}));
                callSiteArray[136].call(proc);
            } else {
                callSiteArray[137].call((Object)this.logger, (Object)"No JBoss instance running");
            }
        } else if (this.isStartingOrRunning()) {
            Object proc = callSiteArray[138].call((Object)new GStringImpl(new Object[]{this.cli}, new String[]{"", " --connect --command=:shutdown"}));
            callSiteArray[139].call(proc);
        } else {
            callSiteArray[140].call((Object)this.logger, (Object)"No JBoss instance running");
        }
    }

    public void reload() {
        CallSite[] callSiteArray = JBossServer.$getCallSiteArray();
        Object proc = callSiteArray[141].call((Object)new GStringImpl(new Object[]{this.cli}, new String[]{"", " --connect --command=:reload"}));
        callSiteArray[142].call(proc);
    }

    private static boolean running(String status) {
        CallSite[] callSiteArray = JBossServer.$getCallSiteArray();
        return ScriptBytecodeAdapter.compareEqual((Object)status, (Object)"running");
    }

    private static boolean starting(String status) {
        CallSite[] callSiteArray = JBossServer.$getCallSiteArray();
        return ScriptBytecodeAdapter.compareEqual((Object)status, (Object)"starting");
    }

    private static boolean stopped(String status) {
        CallSite[] callSiteArray = JBossServer.$getCallSiteArray();
        return ScriptBytecodeAdapter.compareEqual((Object)status, (Object)"stopped");
    }

    private static boolean reloadRequired(String status) {
        CallSite[] callSiteArray = JBossServer.$getCallSiteArray();
        return ScriptBytecodeAdapter.compareEqual((Object)status, (Object)"reload-required");
    }

    public boolean isRunning() {
        CallSite[] callSiteArray = JBossServer.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[143].callStatic(JBossServer.class, callSiteArray[144].callCurrent((GroovyObject)this)));
        }
        return JBossServer.running(this.status());
    }

    public boolean isStarting() {
        CallSite[] callSiteArray = JBossServer.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[145].callStatic(JBossServer.class, callSiteArray[146].callCurrent((GroovyObject)this)));
        }
        return JBossServer.starting(this.status());
    }

    public boolean isStartingOrRunning() {
        CallSite[] callSiteArray = JBossServer.$getCallSiteArray();
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            String status = ShortTypeHandling.castToString((Object)callSiteArray[147].callCurrent((GroovyObject)this));
            return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[148].callStatic(JBossServer.class, (Object)status)) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[149].callStatic(JBossServer.class, (Object)status));
        }
        String status = this.status();
        return JBossServer.starting(status) || JBossServer.running(status);
    }

    public boolean isStopped() {
        CallSite[] callSiteArray = JBossServer.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[150].callStatic(JBossServer.class, callSiteArray[151].callCurrent((GroovyObject)this)));
        }
        return JBossServer.stopped(this.status());
    }

    public String status() {
        CallSite[] callSiteArray = JBossServer.$getCallSiteArray();
        StringBuilder output = (StringBuilder)ScriptBytecodeAdapter.castToType((Object)callSiteArray[152].callConstructor(StringBuilder.class), StringBuilder.class);
        Object proc = callSiteArray[153].call((Object)new GStringImpl(new Object[]{this.cli}, new String[]{"", " --connect --command=:read-attribute(name=server-state)"}));
        callSiteArray[154].call(proc, (Object)output, (Object)output);
        Reference status = new Reference((Object)"stopped");
        if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[155].call(proc), (Object)0)) {
            Matcher matcher = (Matcher)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.findRegex((Object)callSiteArray[156].call((Object)output), (Object)"\"result\" => \"(.+)\""), Matcher.class);
            public final class _status_closure2
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference status;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _status_closure2(Object _outerInstance, Object _thisObject, Reference status) {
                    Reference reference;
                    CallSite[] callSiteArray = _status_closure2.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.status = reference = status;
                }

                public Object doCall(Object token) {
                    CallSite[] callSiteArray = _status_closure2.$getCallSiteArray();
                    Object object = callSiteArray[0].call(token, (Object)1);
                    this.status.set((Object)ShortTypeHandling.castToString((Object)object));
                    return object;
                }

                @Generated
                public String getStatus() {
                    CallSite[] callSiteArray = _status_closure2.$getCallSiteArray();
                    return ShortTypeHandling.castToString((Object)this.status.get());
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _status_closure2.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[1];
                    stringArray[0] = "getAt";
                    return new CallSiteArray(_status_closure2.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _status_closure2.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            callSiteArray[157].call((Object)matcher, (Object)new _status_closure2(this, this, status));
        }
        return (String)status.get();
    }

    public boolean isAlreadyConfigured() {
        CallSite[] callSiteArray = JBossServer.$getCallSiteArray();
        String config = ShortTypeHandling.castToString((Object)callSiteArray[158].callGetProperty(callSiteArray[159].callConstructor(File.class, (Object)new GStringImpl(new Object[]{this.jbossHome}, new String[]{"", "/standalone/configuration/standalone-full.xml"}))));
        return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[160].call((Object)config, (Object)"java:/datasources/silverpeas"));
    }

    public void add(String artifactPath) throws RuntimeException {
        CallSite[] callSiteArray = JBossServer.$getCallSiteArray();
        String artifactName = ShortTypeHandling.castToString((Object)callSiteArray[161].callGetProperty(callSiteArray[162].call(Paths.class, (Object)artifactPath)));
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[163].callCurrent((GroovyObject)this, (Object)artifactPath, (Object)artifactName);
        } else {
            this.add(artifactPath, artifactName);
        }
    }

    public void add(String artifactPath, String context) throws RuntimeException {
        CallSite[] callSiteArray = JBossServer.$getCallSiteArray();
        String artifactName = ShortTypeHandling.castToString((Object)callSiteArray[164].call(FilenameUtils.class, (Object)artifactPath));
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[165].callCurrent((GroovyObject)this, (Object)artifactPath, (Object)artifactName, (Object)context);
        } else {
            this.add(artifactPath, artifactName, context);
        }
    }

    public void add(String artifactPath, String name, String context) throws RuntimeException {
        CallSite[] callSiteArray = JBossServer.$getCallSiteArray();
        String normalizedArtifactPath = ShortTypeHandling.castToString((Object)callSiteArray[166].call(FilenameUtils.class, (Object)artifactPath));
        Path artifactTruePath = (Path)ScriptBytecodeAdapter.castToType((Object)callSiteArray[167].call(Paths.class, (Object)normalizedArtifactPath), Path.class);
        boolean archive = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[168].call(Files.class, (Object)artifactTruePath));
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[169].callCurrent((GroovyObject)this, (Object)name))) {
                Process proc = (Process)ScriptBytecodeAdapter.castToType((Object)callSiteArray[170].callCurrent((GroovyObject)this, (Object)new GStringImpl(new Object[]{name, context, normalizedArtifactPath, archive}, new String[]{"/deployment=", ":add(runtime-name=", ",content=[{path=>", ",archive=", "}])"}), callSiteArray[171].callGetProperty(SystemUtils.class)), Process.class);
                callSiteArray[172].call((Object)proc);
                if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[173].call((Object)proc), (Object)0) || !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[174].callCurrent((GroovyObject)this, (Object)name))) {
                    throw (Throwable)callSiteArray[175].callConstructor(RuntimeException.class, callSiteArray[176].call((Object)new GStringImpl(new Object[]{name}, new String[]{"Adding of ", " in JBoss failed with exit code "}), (Object)new GStringImpl(new Object[]{callSiteArray[177].call((Object)proc), callSiteArray[178].callGetProperty(callSiteArray[179].callGetProperty((Object)proc))}, new String[]{"", " and message ", ""})));
                }
            } else {
                callSiteArray[180].call((Object)this.logger, (Object)new GStringImpl(new Object[]{name}, new String[]{"", " is already added in JBoss"}));
            }
        } else if (!this.isInDeployments(name)) {
            Process proc = (Process)ScriptBytecodeAdapter.castToType((Object)callSiteArray[181].callCurrent((GroovyObject)this, (Object)new GStringImpl(new Object[]{name, context, normalizedArtifactPath, archive}, new String[]{"/deployment=", ":add(runtime-name=", ",content=[{path=>", ",archive=", "}])"}), callSiteArray[182].callGetProperty(SystemUtils.class)), Process.class);
            callSiteArray[183].call((Object)proc);
            if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[184].call((Object)proc), (Object)0) || !this.isInDeployments(name)) {
                throw (Throwable)callSiteArray[185].callConstructor(RuntimeException.class, callSiteArray[186].call((Object)new GStringImpl(new Object[]{name}, new String[]{"Adding of ", " in JBoss failed with exit code "}), (Object)new GStringImpl(new Object[]{callSiteArray[187].call((Object)proc), callSiteArray[188].callGetProperty(callSiteArray[189].callGetProperty((Object)proc))}, new String[]{"", " and message ", ""})));
            }
        } else {
            callSiteArray[190].call((Object)this.logger, (Object)new GStringImpl(new Object[]{name}, new String[]{"", " is already added in JBoss"}));
        }
    }

    public void remove(String artifact) throws RuntimeException {
        CallSite[] callSiteArray = JBossServer.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[191].callCurrent((GroovyObject)this, (Object)artifact))) {
                Process proc = (Process)ScriptBytecodeAdapter.castToType((Object)callSiteArray[192].callCurrent((GroovyObject)this, (Object)new GStringImpl(new Object[]{artifact}, new String[]{"undeploy ", ""})), Process.class);
                callSiteArray[193].call((Object)proc);
                if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[194].call((Object)proc), (Object)0) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[195].callCurrent((GroovyObject)this, (Object)artifact))) {
                    throw (Throwable)callSiteArray[196].callConstructor(RuntimeException.class, callSiteArray[197].call((Object)new GStringImpl(new Object[]{artifact}, new String[]{"Remove of ", " from JBoss failed with exit code "}), (Object)new GStringImpl(new Object[]{callSiteArray[198].call((Object)proc), callSiteArray[199].callGetProperty(callSiteArray[200].callGetProperty((Object)proc))}, new String[]{"", " and message ", ""})));
                }
            } else {
                callSiteArray[201].call((Object)this.logger, (Object)new GStringImpl(new Object[]{artifact}, new String[]{"", " isn't deployed in JBoss"}));
            }
        } else if (this.isInDeployments(artifact)) {
            Process proc = (Process)ScriptBytecodeAdapter.castToType((Object)callSiteArray[202].callCurrent((GroovyObject)this, (Object)new GStringImpl(new Object[]{artifact}, new String[]{"undeploy ", ""})), Process.class);
            callSiteArray[203].call((Object)proc);
            if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[204].call((Object)proc), (Object)0) || this.isInDeployments(artifact)) {
                throw (Throwable)callSiteArray[205].callConstructor(RuntimeException.class, callSiteArray[206].call((Object)new GStringImpl(new Object[]{artifact}, new String[]{"Remove of ", " from JBoss failed with exit code "}), (Object)new GStringImpl(new Object[]{callSiteArray[207].call((Object)proc), callSiteArray[208].callGetProperty(callSiteArray[209].callGetProperty((Object)proc))}, new String[]{"", " and message ", ""})));
            }
        } else {
            callSiteArray[210].call((Object)this.logger, (Object)new GStringImpl(new Object[]{artifact}, new String[]{"", " isn't deployed in JBoss"}));
        }
    }

    public void deploy(String artifact) throws RuntimeException {
        CallSite[] callSiteArray = JBossServer.$getCallSiteArray();
        Process proc = (Process)ScriptBytecodeAdapter.castToType((Object)callSiteArray[211].callCurrent((GroovyObject)this, (Object)new GStringImpl(new Object[]{artifact}, new String[]{"/deployment=", ":deploy()"})), Process.class);
        callSiteArray[212].call((Object)proc);
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[213].call((Object)proc), (Object)0) || !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[214].callCurrent((GroovyObject)this, (Object)artifact))) {
                throw (Throwable)callSiteArray[215].callConstructor(RuntimeException.class, callSiteArray[216].call((Object)new GStringImpl(new Object[]{artifact}, new String[]{"Deployment of ", " failed with exit code "}), (Object)new GStringImpl(new Object[]{callSiteArray[217].call((Object)proc), callSiteArray[218].callGetProperty(callSiteArray[219].callGetProperty((Object)proc))}, new String[]{"", " and message ", ""})));
            }
        } else if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[220].call((Object)proc), (Object)0) || !this.isDeployed(artifact)) {
            throw (Throwable)callSiteArray[221].callConstructor(RuntimeException.class, callSiteArray[222].call((Object)new GStringImpl(new Object[]{artifact}, new String[]{"Deployment of ", " failed with exit code "}), (Object)new GStringImpl(new Object[]{callSiteArray[223].call((Object)proc), callSiteArray[224].callGetProperty(callSiteArray[225].callGetProperty((Object)proc))}, new String[]{"", " and message ", ""})));
        }
    }

    public void undeploy(String artifact) throws RuntimeException {
        CallSite[] callSiteArray = JBossServer.$getCallSiteArray();
        Process proc = (Process)ScriptBytecodeAdapter.castToType((Object)callSiteArray[226].callCurrent((GroovyObject)this, (Object)new GStringImpl(new Object[]{artifact}, new String[]{"/deployment=", ":undeploy()"})), Process.class);
        callSiteArray[227].call((Object)proc);
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[228].call((Object)proc), (Object)0) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[229].callCurrent((GroovyObject)this, (Object)artifact))) {
                throw (Throwable)callSiteArray[230].callConstructor(RuntimeException.class, callSiteArray[231].call((Object)new GStringImpl(new Object[]{artifact}, new String[]{"Deployment of ", " failed with exit code "}), (Object)new GStringImpl(new Object[]{callSiteArray[232].call((Object)proc), callSiteArray[233].callGetProperty(callSiteArray[234].callGetProperty((Object)proc))}, new String[]{"", " and message ", ""})));
            }
        } else if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[235].call((Object)proc), (Object)0) || this.isDeployed(artifact)) {
            throw (Throwable)callSiteArray[236].callConstructor(RuntimeException.class, callSiteArray[237].call((Object)new GStringImpl(new Object[]{artifact}, new String[]{"Deployment of ", " failed with exit code "}), (Object)new GStringImpl(new Object[]{callSiteArray[238].call((Object)proc), callSiteArray[239].callGetProperty(callSiteArray[240].callGetProperty((Object)proc))}, new String[]{"", " and message ", ""})));
        }
    }

    public boolean isDeployed(String artifact) {
        CallSite[] callSiteArray = JBossServer.$getCallSiteArray();
        Process proc = (Process)ScriptBytecodeAdapter.castToType((Object)callSiteArray[241].callCurrent((GroovyObject)this, (Object)new GStringImpl(new Object[]{artifact}, new String[]{"/deployment=", ":read-attribute(name=enabled)"})), Process.class);
        callSiteArray[242].call((Object)proc);
        return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[243].call(callSiteArray[244].callGetProperty(callSiteArray[245].callGetProperty((Object)proc)), (Object)"\"result\" => true"));
    }

    public boolean isInDeployments(String artifact) {
        CallSite[] callSiteArray = JBossServer.$getCallSiteArray();
        Process proc = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[246].callCurrent((GroovyObject)this, (Object)"ls deployment");
            proc = (Process)ScriptBytecodeAdapter.castToType((Object)object, Process.class);
        } else {
            Process process;
            proc = process = this.executeCliCommand("ls deployment");
        }
        callSiteArray[247].call((Object)proc);
        return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[248].call(callSiteArray[249].callGetProperty(callSiteArray[250].callGetProperty((Object)proc)), (Object)artifact));
    }

    public void processCommandFile(File commandsFile) throws Exception {
        CallSite[] callSiteArray = JBossServer.$getCallSiteArray();
        try {
            callSiteArray[251].call((Object)this.logger, (Object)new GStringImpl(new Object[]{callSiteArray[252].callGetProperty((Object)commandsFile)}, new String[]{"", " processing..."}));
            Object proc = callSiteArray[253].call((Object)new GStringImpl(new Object[]{this.cli, callSiteArray[254].callGetProperty((Object)commandsFile)}, new String[]{"", " --connect --file=", ""}));
            callSiteArray[255].call(proc);
            callSiteArray[256].callStatic(JBossServer.class, proc);
            if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[257].callCurrent((GroovyObject)this), (Object)"starting")) {
                    callSiteArray[258].call((Object)this.logger, (Object)new GStringImpl(new Object[]{callSiteArray[259].callGetProperty((Object)commandsFile)}, new String[]{"", " processing: JBoss/Wildfly reloading..."}));
                    while (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[260].callCurrent((GroovyObject)this))) {
                        callSiteArray[261].callCurrent((GroovyObject)this, (Object)1000);
                    }
                    callSiteArray[262].call((Object)this.logger, (Object)new GStringImpl(new Object[]{callSiteArray[263].callGetProperty((Object)commandsFile)}, new String[]{"", " processing: JBoss/Wildfly reloaded"}));
                }
            } else if (ScriptBytecodeAdapter.compareEqual((Object)this.status(), (Object)"starting")) {
                callSiteArray[264].call((Object)this.logger, (Object)new GStringImpl(new Object[]{callSiteArray[265].callGetProperty((Object)commandsFile)}, new String[]{"", " processing: JBoss/Wildfly reloading..."}));
                while (!this.isRunning()) {
                    callSiteArray[266].callCurrent((GroovyObject)this, (Object)1000);
                }
                callSiteArray[267].call((Object)this.logger, (Object)new GStringImpl(new Object[]{callSiteArray[268].callGetProperty((Object)commandsFile)}, new String[]{"", " processing: JBoss/Wildfly reloaded"}));
            }
            callSiteArray[269].call((Object)this.logger, (Object)new GStringImpl(new Object[]{callSiteArray[270].callGetProperty((Object)commandsFile)}, new String[]{"", " processing: [OK]"}));
        }
        catch (InvalidObjectException e) {
            callSiteArray[271].call((Object)this.logger, (Object)new GStringImpl(new Object[]{callSiteArray[272].callGetProperty((Object)commandsFile)}, new String[]{"", " processing: [WARNING]"}));
            callSiteArray[273].call((Object)this.logger, (Object)new GStringImpl(new Object[]{callSiteArray[274].callGetProperty((Object)e)}, new String[]{"Invalid resource. ", ""}));
        }
        catch (AssertionError e) {
            callSiteArray[275].call((Object)this.logger, (Object)new GStringImpl(new Object[]{callSiteArray[276].callGetProperty((Object)commandsFile)}, new String[]{"", " processing: [FAILURE]"}));
            callSiteArray[277].call((Object)this.logger, callSiteArray[278].callGetProperty((Object)e));
            throw (Throwable)((Object)e);
        }
        catch (Exception e) {
            callSiteArray[279].call((Object)this.logger, (Object)new GStringImpl(new Object[]{callSiteArray[280].callGetProperty((Object)commandsFile)}, new String[]{"", " processing: [FAILURE]"}));
            callSiteArray[281].call((Object)this.logger, callSiteArray[282].callGetProperty((Object)e));
            throw (Throwable)e;
        }
    }

    public Process executeCliCommand(String commands, boolean wrapIntoDoubleQuotes) {
        CallSite[] callSiteArray = JBossServer.$getCallSiteArray();
        String finalCommands = commands;
        if (wrapIntoDoubleQuotes) {
            Object object = callSiteArray[283].call(callSiteArray[284].call((Object)"\"", (Object)finalCommands), (Object)"\"");
            finalCommands = ShortTypeHandling.castToString((Object)object);
        }
        return (Process)ScriptBytecodeAdapter.castToType((Object)callSiteArray[285].call(callSiteArray[286].call(callSiteArray[287].callConstructor(ProcessBuilder.class, (Object)this.cli, (Object)"--connect", (Object)finalCommands), (Object)true)), Process.class);
    }

    @Generated
    public void start() {
        CallSite[] callSiteArray = JBossServer.$getCallSiteArray();
        this.start(null);
    }

    @Generated
    public void debug() {
        CallSite[] callSiteArray = JBossServer.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            this.debug(5005);
        } else {
            this.debug(5005);
        }
    }

    @Generated
    public Process executeCliCommand(String commands) {
        CallSite[] callSiteArray = JBossServer.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.executeCliCommand(commands, false);
        }
        return this.executeCliCommand(commands, false);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != JBossServer.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public static /* synthetic */ void __$swapInit() {
        long l;
        CallSite[] callSiteArray = JBossServer.$getCallSiteArray();
        $callSiteArray = null;
        $const$0 = l = 300000L;
    }

    static {
        long l;
        JBossServer.__$swapInit();
        DEFAULT_TIMEOUT = l = 300000L;
    }

    @Generated
    public static long getDEFAULT_TIMEOUT() {
        return DEFAULT_TIMEOUT;
    }

    @Generated
    public static void setDEFAULT_TIMEOUT(long l) {
        DEFAULT_TIMEOUT = l;
    }

    @Generated
    public final String getJbossHome() {
        return this.jbossHome;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "getLogger";
        stringArray[1] = "getSimpleName";
        stringArray[2] = "getClass";
        stringArray[3] = "out";
        stringArray[4] = "indexOf";
        stringArray[5] = "toLowerCase";
        stringArray[6] = "getProperty";
        stringArray[7] = "isRunning";
        stringArray[8] = "<$constructor$>";
        stringArray[9] = "<$constructor$>";
        stringArray[10] = "text";
        stringArray[11] = "in";
        stringArray[12] = "exitValue";
        stringArray[13] = "contains";
        stringArray[14] = "contains";
        stringArray[15] = "<$constructor$>";
        stringArray[16] = "<$constructor$>";
        stringArray[17] = "formatInfo";
        stringArray[18] = "status";
        stringArray[19] = "currentTimeMillis";
        stringArray[20] = "running";
        stringArray[21] = "reloadRequired";
        stringArray[22] = "reload";
        stringArray[23] = "sleep";
        stringArray[24] = "minus";
        stringArray[25] = "currentTimeMillis";
        stringArray[26] = "error";
        stringArray[27] = "<$constructor$>";
        stringArray[28] = "formatInfo";
        stringArray[29] = "status";
        stringArray[30] = "status";
        stringArray[31] = "stopped";
        stringArray[32] = "info";
        stringArray[33] = "start";
        stringArray[34] = "starting";
        stringArray[35] = "info";
        stringArray[36] = "waitUntilRunning";
        stringArray[37] = "reloadRequired";
        stringArray[38] = "info";
        stringArray[39] = "execute";
        stringArray[40] = "waitFor";
        stringArray[41] = "waitUntilRunning";
        stringArray[42] = "info";
        stringArray[43] = "info";
        stringArray[44] = "info";
        stringArray[45] = "execute";
        stringArray[46] = "waitFor";
        stringArray[47] = "call";
        stringArray[48] = "execute";
        stringArray[49] = "waitFor";
        stringArray[50] = "exitValue";
        stringArray[51] = "text";
        stringArray[52] = "in";
        stringArray[53] = "each";
        stringArray[54] = "empty";
        stringArray[55] = "trim";
        stringArray[56] = "adminOnly";
        stringArray[57] = "adminOnly";
        stringArray[58] = "reloadRequired";
        stringArray[59] = "status";
        stringArray[60] = "reload";
        stringArray[61] = "stop";
        stringArray[62] = "isStartingOrRunning";
        stringArray[63] = "<$constructor$>";
        stringArray[64] = "<$constructor$>";
        stringArray[65] = "<$constructor$>";
        stringArray[66] = "redirectErrorStream";
        stringArray[67] = "directory";
        stringArray[68] = "<$constructor$>";
        stringArray[69] = "redirectOutput";
        stringArray[70] = "inheritIO";
        stringArray[71] = "println";
        stringArray[72] = "redirectOutput";
        stringArray[73] = "start";
        stringArray[74] = "waitUntilRunning";
        stringArray[75] = "println";
        stringArray[76] = "println";
        stringArray[77] = "info";
        stringArray[78] = "<$constructor$>";
        stringArray[79] = "<$constructor$>";
        stringArray[80] = "<$constructor$>";
        stringArray[81] = "redirectErrorStream";
        stringArray[82] = "directory";
        stringArray[83] = "<$constructor$>";
        stringArray[84] = "redirectOutput";
        stringArray[85] = "inheritIO";
        stringArray[86] = "println";
        stringArray[87] = "redirectOutput";
        stringArray[88] = "start";
        stringArray[89] = "println";
        stringArray[90] = "println";
        stringArray[91] = "info";
        stringArray[92] = "reloadRequired";
        stringArray[93] = "status";
        stringArray[94] = "reload";
        stringArray[95] = "stop";
        stringArray[96] = "isStartingOrRunning";
        stringArray[97] = "valueOf";
        stringArray[98] = "redirectErrorStream";
        stringArray[99] = "directory";
        stringArray[100] = "<$constructor$>";
        stringArray[101] = "<$constructor$>";
        stringArray[102] = "redirectErrorStream";
        stringArray[103] = "directory";
        stringArray[104] = "<$constructor$>";
        stringArray[105] = "<$constructor$>";
        stringArray[106] = "redirectOutput";
        stringArray[107] = "inheritIO";
        stringArray[108] = "println";
        stringArray[109] = "redirectOutput";
        stringArray[110] = "start";
        stringArray[111] = "waitUntilRunning";
        stringArray[112] = "println";
        stringArray[113] = "println";
        stringArray[114] = "println";
        stringArray[115] = "info";
        stringArray[116] = "valueOf";
        stringArray[117] = "redirectErrorStream";
        stringArray[118] = "directory";
        stringArray[119] = "<$constructor$>";
        stringArray[120] = "<$constructor$>";
        stringArray[121] = "redirectErrorStream";
        stringArray[122] = "directory";
        stringArray[123] = "<$constructor$>";
        stringArray[124] = "<$constructor$>";
        stringArray[125] = "redirectOutput";
        stringArray[126] = "inheritIO";
        stringArray[127] = "println";
        stringArray[128] = "redirectOutput";
        stringArray[129] = "start";
        stringArray[130] = "println";
        stringArray[131] = "println";
        stringArray[132] = "println";
        stringArray[133] = "info";
        stringArray[134] = "isStartingOrRunning";
        stringArray[135] = "execute";
        stringArray[136] = "waitFor";
        stringArray[137] = "info";
        stringArray[138] = "execute";
        stringArray[139] = "waitFor";
        stringArray[140] = "info";
        stringArray[141] = "execute";
        stringArray[142] = "waitFor";
        stringArray[143] = "running";
        stringArray[144] = "status";
        stringArray[145] = "starting";
        stringArray[146] = "status";
        stringArray[147] = "status";
        stringArray[148] = "starting";
        stringArray[149] = "running";
        stringArray[150] = "stopped";
        stringArray[151] = "status";
        stringArray[152] = "<$constructor$>";
        stringArray[153] = "execute";
        stringArray[154] = "waitForProcessOutput";
        stringArray[155] = "exitValue";
        stringArray[156] = "toString";
        stringArray[157] = "each";
        stringArray[158] = "text";
        stringArray[159] = "<$constructor$>";
        stringArray[160] = "contains";
        stringArray[161] = "fileName";
        stringArray[162] = "get";
        stringArray[163] = "add";
        stringArray[164] = "getName";
        stringArray[165] = "add";
        stringArray[166] = "separatorsToUnix";
        stringArray[167] = "get";
        stringArray[168] = "isRegularFile";
        stringArray[169] = "isInDeployments";
        stringArray[170] = "executeCliCommand";
        stringArray[171] = "IS_OS_WINDOWS";
        stringArray[172] = "waitFor";
        stringArray[173] = "exitValue";
        stringArray[174] = "isInDeployments";
        stringArray[175] = "<$constructor$>";
        stringArray[176] = "plus";
        stringArray[177] = "exitValue";
        stringArray[178] = "text";
        stringArray[179] = "in";
        stringArray[180] = "info";
        stringArray[181] = "executeCliCommand";
        stringArray[182] = "IS_OS_WINDOWS";
        stringArray[183] = "waitFor";
        stringArray[184] = "exitValue";
        stringArray[185] = "<$constructor$>";
        stringArray[186] = "plus";
        stringArray[187] = "exitValue";
        stringArray[188] = "text";
        stringArray[189] = "in";
        stringArray[190] = "info";
        stringArray[191] = "isInDeployments";
        stringArray[192] = "executeCliCommand";
        stringArray[193] = "waitFor";
        stringArray[194] = "exitValue";
        stringArray[195] = "isInDeployments";
        stringArray[196] = "<$constructor$>";
        stringArray[197] = "plus";
        stringArray[198] = "exitValue";
        stringArray[199] = "text";
        stringArray[200] = "in";
        stringArray[201] = "info";
        stringArray[202] = "executeCliCommand";
        stringArray[203] = "waitFor";
        stringArray[204] = "exitValue";
        stringArray[205] = "<$constructor$>";
        stringArray[206] = "plus";
        stringArray[207] = "exitValue";
        stringArray[208] = "text";
        stringArray[209] = "in";
        stringArray[210] = "info";
        stringArray[211] = "executeCliCommand";
        stringArray[212] = "waitFor";
        stringArray[213] = "exitValue";
        stringArray[214] = "isDeployed";
        stringArray[215] = "<$constructor$>";
        stringArray[216] = "plus";
        stringArray[217] = "exitValue";
        stringArray[218] = "text";
        stringArray[219] = "in";
        stringArray[220] = "exitValue";
        stringArray[221] = "<$constructor$>";
        stringArray[222] = "plus";
        stringArray[223] = "exitValue";
        stringArray[224] = "text";
        stringArray[225] = "in";
        stringArray[226] = "executeCliCommand";
        stringArray[227] = "waitFor";
        stringArray[228] = "exitValue";
        stringArray[229] = "isDeployed";
        stringArray[230] = "<$constructor$>";
        stringArray[231] = "plus";
        stringArray[232] = "exitValue";
        stringArray[233] = "text";
        stringArray[234] = "in";
        stringArray[235] = "exitValue";
        stringArray[236] = "<$constructor$>";
        stringArray[237] = "plus";
        stringArray[238] = "exitValue";
        stringArray[239] = "text";
        stringArray[240] = "in";
        stringArray[241] = "executeCliCommand";
        stringArray[242] = "waitFor";
        stringArray[243] = "contains";
        stringArray[244] = "text";
        stringArray[245] = "in";
        stringArray[246] = "executeCliCommand";
        stringArray[247] = "waitFor";
        stringArray[248] = "contains";
        stringArray[249] = "text";
        stringArray[250] = "in";
        stringArray[251] = "info";
        stringArray[252] = "name";
        stringArray[253] = "execute";
        stringArray[254] = "path";
        stringArray[255] = "waitFor";
        stringArray[256] = "assertCommandSucceeds";
        stringArray[257] = "status";
        stringArray[258] = "info";
        stringArray[259] = "name";
        stringArray[260] = "isRunning";
        stringArray[261] = "sleep";
        stringArray[262] = "info";
        stringArray[263] = "name";
        stringArray[264] = "info";
        stringArray[265] = "name";
        stringArray[266] = "sleep";
        stringArray[267] = "info";
        stringArray[268] = "name";
        stringArray[269] = "info";
        stringArray[270] = "name";
        stringArray[271] = "info";
        stringArray[272] = "name";
        stringArray[273] = "warn";
        stringArray[274] = "message";
        stringArray[275] = "info";
        stringArray[276] = "name";
        stringArray[277] = "error";
        stringArray[278] = "message";
        stringArray[279] = "info";
        stringArray[280] = "name";
        stringArray[281] = "error";
        stringArray[282] = "message";
        stringArray[283] = "plus";
        stringArray[284] = "plus";
        stringArray[285] = "start";
        stringArray[286] = "redirectErrorStream";
        stringArray[287] = "<$constructor$>";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[288];
        JBossServer.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(JBossServer.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = JBossServer.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

