/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.yellowpages;

import javax.inject.Named;
import javax.transaction.Transactional;
import org.silverpeas.core.admin.component.ComponentInstancePostConstruction;
import org.silverpeas.core.admin.service.AdministrationServiceProvider;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.node.model.NodeDetail;
import org.silverpeas.core.node.model.NodePK;
import org.silverpeas.core.node.service.NodeService;
import org.silverpeas.kernel.util.StringUtil;

@Named
public class YellowpagesInstancePostConstruction
implements ComponentInstancePostConstruction {
    @Transactional
    public void postConstruct(String componentInstanceId) {
        NodeService nodeService = NodeService.get();
        NodeDetail contacts = this.getContactsNodeFor(componentInstanceId);
        NodeDetail bin = this.getBinNodeFor(componentInstanceId, contacts);
        NodeDetail dz = this.getDzNodeFor(componentInstanceId, contacts);
        nodeService.createNode(contacts);
        nodeService.createNode(bin);
        nodeService.createNode(dz);
    }

    private NodeDetail getContactsNodeFor(String componentInstanceId) {
        NodeDetail root = new NodeDetail();
        root.setNodePK(new NodePK("0", componentInstanceId));
        root.setFatherPK(null);
        root.setUseId(true);
        root.setName("Accueil");
        root.setDescription("");
        root.setCreatorId(UserDetail.getCurrentRequester().getId());
        root.setLevel(1);
        String xmlFilename = AdministrationServiceProvider.getAdminService().getComponentParameterValue(componentInstanceId, "xmlTemplate");
        if (StringUtil.isDefined((String)xmlFilename)) {
            root.setModelId(xmlFilename);
        }
        return root;
    }

    private NodeDetail getBinNodeFor(String componentInstanceId, NodeDetail root) {
        NodeDetail bin = new NodeDetail();
        bin.setNodePK(new NodePK("1", componentInstanceId));
        bin.setFatherPK(root.getNodePK());
        bin.setUseId(true);
        bin.setName("Corbeille");
        bin.setDescription("Vous trouvez ici les contacts que vous avez supprim\u00e9");
        bin.setCreatorId(UserDetail.getCurrentRequester().getId());
        bin.setLevel(2);
        return bin;
    }

    private NodeDetail getDzNodeFor(String componentInstanceId, NodeDetail root) {
        NodeDetail dz = new NodeDetail();
        dz.setNodePK(new NodePK("2", componentInstanceId));
        dz.setFatherPK(root.getNodePK());
        dz.setUseId(true);
        dz.setName("D\u00e9class\u00e9es");
        dz.setDescription("Vos contacts inaccessibles se retrouvent ici");
        dz.setCreatorId(UserDetail.getCurrentRequester().getId());
        dz.setLevel(2);
        return dz;
    }
}

