/*
 * Decompiled with CFR 0.152.
 */
package com.google.auth.oauth2;

import com.google.auth.http.HttpTransportFactory;
import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.CredentialAccessBoundary;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.OAuth2Credentials;
import com.google.auth.oauth2.OAuth2Utils;
import com.google.auth.oauth2.StsRequestHandler;
import com.google.auth.oauth2.StsTokenExchangeRequest;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.IOException;

public final class DownscopedCredentials
extends OAuth2Credentials {
    private static final String TOKEN_EXCHANGE_ENDPOINT = "https://sts.googleapis.com/v1/token";
    private final GoogleCredentials sourceCredential;
    private final CredentialAccessBoundary credentialAccessBoundary;
    private final transient HttpTransportFactory transportFactory;

    private DownscopedCredentials(GoogleCredentials sourceCredential, CredentialAccessBoundary credentialAccessBoundary, HttpTransportFactory transportFactory) {
        this.transportFactory = (HttpTransportFactory)MoreObjects.firstNonNull((Object)transportFactory, (Object)DownscopedCredentials.getFromServiceLoader(HttpTransportFactory.class, OAuth2Utils.HTTP_TRANSPORT_FACTORY));
        this.sourceCredential = (GoogleCredentials)((Object)Preconditions.checkNotNull((Object)((Object)sourceCredential)));
        this.credentialAccessBoundary = (CredentialAccessBoundary)Preconditions.checkNotNull((Object)credentialAccessBoundary);
    }

    @Override
    public AccessToken refreshAccessToken() throws IOException {
        AccessToken sourceAccessToken;
        try {
            this.sourceCredential.refreshIfExpired();
        }
        catch (IOException e) {
            throw new IOException("Unable to refresh the provided source credential.", e);
        }
        StsTokenExchangeRequest request = StsTokenExchangeRequest.newBuilder(this.sourceCredential.getAccessToken().getTokenValue(), "urn:ietf:params:oauth:token-type:access_token").setRequestTokenType("urn:ietf:params:oauth:token-type:access_token").build();
        StsRequestHandler handler = StsRequestHandler.newBuilder(TOKEN_EXCHANGE_ENDPOINT, request, this.transportFactory.create().createRequestFactory()).setInternalOptions(this.credentialAccessBoundary.toJson()).build();
        AccessToken downscopedAccessToken = handler.exchangeToken().getAccessToken();
        if (downscopedAccessToken.getExpirationTime() == null && (sourceAccessToken = this.sourceCredential.getAccessToken()).getExpirationTime() != null) {
            return new AccessToken(downscopedAccessToken.getTokenValue(), sourceAccessToken.getExpirationTime());
        }
        return downscopedAccessToken;
    }

    public GoogleCredentials getSourceCredentials() {
        return this.sourceCredential;
    }

    public CredentialAccessBoundary getCredentialAccessBoundary() {
        return this.credentialAccessBoundary;
    }

    @VisibleForTesting
    HttpTransportFactory getTransportFactory() {
        return this.transportFactory;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    extends OAuth2Credentials.Builder {
        private GoogleCredentials sourceCredential;
        private CredentialAccessBoundary credentialAccessBoundary;
        private HttpTransportFactory transportFactory;

        private Builder() {
        }

        public Builder setSourceCredential(GoogleCredentials sourceCredential) {
            this.sourceCredential = sourceCredential;
            return this;
        }

        public Builder setCredentialAccessBoundary(CredentialAccessBoundary credentialAccessBoundary) {
            this.credentialAccessBoundary = credentialAccessBoundary;
            return this;
        }

        public Builder setHttpTransportFactory(HttpTransportFactory transportFactory) {
            this.transportFactory = transportFactory;
            return this;
        }

        @Override
        public DownscopedCredentials build() {
            return new DownscopedCredentials(this.sourceCredential, this.credentialAccessBoundary, this.transportFactory);
        }
    }
}

