/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.kmelia.service;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.silverpeas.components.kmelia.service.KmeliaService;
import org.silverpeas.core.contribution.publication.model.PublicationDetail;
import org.silverpeas.core.contribution.publication.model.PublicationPK;

class KmeliaValidation {
    private final String validatorId;
    private boolean force = false;
    private boolean validatorHasNoMoreRight = false;
    private Set<PublicationPK> pubPkOfPerformedValidations = new HashSet<PublicationPK>(500);

    private KmeliaValidation(String validatorId) {
        this.validatorId = validatorId;
    }

    public static KmeliaValidation by(String validatorId) {
        return new KmeliaValidation(validatorId);
    }

    KmeliaValidation forceValidation() {
        if (this.validatorHasNoMoreRight) {
            throw new IllegalArgumentException("forces the validation whereas the validator has no more right to validate");
        }
        this.force = true;
        return this;
    }

    KmeliaValidation validatorHasNoMoreRight() {
        if (this.force) {
            throw new IllegalArgumentException("indicates the validator ha no more right to validate whereas the validation is indicated to be forced");
        }
        this.validatorHasNoMoreRight = true;
        return this;
    }

    void validate(List<PublicationDetail> publications) {
        for (PublicationDetail publication : publications) {
            this.validate(publication);
        }
    }

    void validate(PublicationDetail publication) {
        if (!(this.force || publication.isClone() || publication.isValidationRequired())) {
            return;
        }
        PublicationPK publicationPkToValidate = null;
        if (publication.isClone()) {
            PublicationDetail clone = this.getKmeliaService().getPublicationDetail(publication.getPK());
            if (clone != null && (this.force || clone.isValidationRequired())) {
                publicationPkToValidate = publication.getClonePK();
            }
        } else {
            publicationPkToValidate = publication.getPK();
        }
        if (publicationPkToValidate != null && !this.pubPkOfPerformedValidations.contains(publicationPkToValidate)) {
            this.getKmeliaService().validatePublication(publicationPkToValidate, this.validatorId, this.force, this.validatorHasNoMoreRight);
            this.pubPkOfPerformedValidations.add(publicationPkToValidate);
        }
    }

    private KmeliaService getKmeliaService() {
        return KmeliaService.get();
    }
}

